/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.HashMap;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.NonClosingCheckpointOutputStream;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.util.LongArrayList;

@PublicEvolving
public final class OperatorStateCheckpointOutputStream
extends NonClosingCheckpointOutputStream<OperatorStateHandle> {
    private LongArrayList partitionOffsets = new LongArrayList(16);
    private final long initialPosition;

    public OperatorStateCheckpointOutputStream(CheckpointStreamFactory.CheckpointStateOutputStream delegate2) throws IOException {
        super(delegate2);
        this.initialPosition = delegate2.getPos();
    }

    public void startNewPartition() throws IOException {
        this.partitionOffsets.add(this.delegate.getPos());
    }

    @Override
    OperatorStateHandle closeAndGetHandle() throws IOException {
        StreamStateHandle streamStateHandle = this.delegate.closeAndGetHandle();
        if (null == streamStateHandle) {
            return null;
        }
        if (this.partitionOffsets.isEmpty() && this.delegate.getPos() > this.initialPosition) {
            this.startNewPartition();
        }
        HashMap<String, OperatorStateHandle.StateMetaInfo> offsetsMap = new HashMap<String, OperatorStateHandle.StateMetaInfo>(1);
        OperatorStateHandle.StateMetaInfo metaInfo = new OperatorStateHandle.StateMetaInfo(this.partitionOffsets.toArray(), OperatorStateHandle.Mode.SPLIT_DISTRIBUTE);
        offsetsMap.put("_default_", metaInfo);
        return new OperatorStreamStateHandle(offsetsMap, streamStateHandle);
    }

    public int getNumberOfPartitions() {
        return this.partitionOffsets.size();
    }
}

