/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.PlaceholderStreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileSegmentStateHandle;

public class PlaceholderSegmentStateHandle
extends PlaceholderStreamStateHandle {
    private static final long serialVersionUID = 1L;
    private final Path filePath;
    private final long startPosition;
    private final long endPosition;
    private final long segmentSize;
    private final boolean fileClosed;

    public PlaceholderSegmentStateHandle(FileSegmentStateHandle fileSegmentStateHandle) {
        this(fileSegmentStateHandle.getFilePath(), fileSegmentStateHandle.getStartPosition(), fileSegmentStateHandle.getEndPosition(), fileSegmentStateHandle.isFileClosed());
    }

    private PlaceholderSegmentStateHandle(Path filePath, long startPosition, long endPosition, boolean fileClosed) {
        this.filePath = filePath;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.segmentSize = endPosition - startPosition;
        this.fileClosed = fileClosed;
    }

    @Override
    public long getStateSize() {
        return 0L;
    }

    @Override
    public long getFullStateSize() {
        return this.segmentSize;
    }

    public boolean isFileClosed() {
        return this.fileClosed;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getEndPosition() {
        return this.endPosition;
    }

    public FileSegmentStateHandle toFileSegmentStateHandle() {
        return new FileSegmentStateHandle(this.filePath, this.startPosition, this.endPosition, this.fileClosed);
    }
}

