/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.SortedMapSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.keyed.KeyedListStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedValueStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueStateDescriptor;
import org.apache.flink.util.Preconditions;

public class StateMetaInfoSnapshot {
    private final InternalStateType stateType;
    private final String name;
    private final TypeSerializer keySerializer;
    private final TypeSerializer valueSerializer;
    protected final TypeSerializer namespaceSerializer;
    private final TypeSerializerConfigSnapshot keySerializerConfigSnapshot;
    private final TypeSerializerConfigSnapshot valueSerializerConfigSnapshot;
    private final TypeSerializerConfigSnapshot namespaceSerializerConfigSnapshot;

    public StateMetaInfoSnapshot(InternalStateType stateType, String name, TypeSerializer keySerializer, TypeSerializer valueSerializer, TypeSerializer namespaceSerializer, TypeSerializerConfigSnapshot keySerializerConfigSnapshot, TypeSerializerConfigSnapshot valueSerializerConfigSnapshot, TypeSerializerConfigSnapshot namespaceSerializerConfigSnapshot) {
        this.stateType = (InternalStateType)((Object)Preconditions.checkNotNull((Object)((Object)stateType)));
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull((Object)keySerializer);
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull((Object)valueSerializer);
        this.namespaceSerializer = (TypeSerializer)Preconditions.checkNotNull((Object)namespaceSerializer);
        this.keySerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)keySerializerConfigSnapshot);
        this.valueSerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)valueSerializerConfigSnapshot);
        this.namespaceSerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)namespaceSerializerConfigSnapshot);
    }

    public InternalStateType getStateType() {
        return this.stateType;
    }

    public String getName() {
        return this.name;
    }

    public TypeSerializer getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    public TypeSerializerConfigSnapshot getKeySerializerConfigSnapshot() {
        return this.keySerializerConfigSnapshot;
    }

    public TypeSerializerConfigSnapshot getValueSerializerConfigSnapshot() {
        return this.valueSerializerConfigSnapshot;
    }

    public TypeSerializer getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializerConfigSnapshot getNamespaceSerializerConfigSnapshot() {
        return this.namespaceSerializerConfigSnapshot;
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getKeySerializer().hashCode();
        result = 31 * result + this.getValueSerializer().hashCode();
        result = 31 * result + this.getNamespaceSerializer().hashCode();
        result = 31 * result + this.getKeySerializerConfigSnapshot().hashCode();
        result = 31 * result + this.getValueSerializerConfigSnapshot().hashCode();
        result = 31 * result + this.getNamespaceSerializerConfigSnapshot().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMetaInfoSnapshot that = (StateMetaInfoSnapshot)o;
        if (!this.stateType.equals((Object)that.stateType)) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getKeySerializer().equals((Object)that.getKeySerializer()) && this.getValueSerializer().equals((Object)that.getValueSerializer()) && Objects.equals(this.getNamespaceSerializer(), that.getNamespaceSerializer()) && this.getKeySerializerConfigSnapshot().equals((Object)that.getKeySerializerConfigSnapshot()) && this.getValueSerializerConfigSnapshot().equals((Object)that.getValueSerializerConfigSnapshot()) && Objects.equals(this.getNamespaceSerializerConfigSnapshot(), that.getNamespaceSerializerConfigSnapshot());
    }

    public KeyedStateDescriptor createKeyedStateDescriptor() {
        Preconditions.checkState((boolean)this.stateType.isKeyedState(), (Object)"Expected keyed state meta snapshot.");
        String name = this.getName();
        TypeSerializer keySerializer = this.getKeySerializer();
        TypeSerializer valueSerializer = this.getValueSerializer();
        switch (this.getStateType()) {
            case KEYED_VALUE: {
                return new KeyedValueStateDescriptor(name, keySerializer, valueSerializer);
            }
            case KEYED_LIST: {
                return new KeyedListStateDescriptor(name, keySerializer, (ListSerializer)valueSerializer);
            }
            case KEYED_MAP: {
                return new KeyedMapStateDescriptor(name, keySerializer, (MapSerializer)valueSerializer);
            }
            case KEYED_SORTEDMAP: {
                return new KeyedSortedMapStateDescriptor(name, keySerializer, (SortedMapSerializer)valueSerializer);
            }
        }
        throw new IllegalStateException("Unknown internal state type for " + (Object)((Object)this.getStateType()));
    }

    public SubKeyedStateDescriptor createSubKeyedStateDescriptor() {
        Preconditions.checkState((!this.stateType.isKeyedState() ? 1 : 0) != 0, (Object)"Expected subKeyed state meta snapshot.");
        String name = this.getName();
        TypeSerializer keySerializer = this.getKeySerializer();
        TypeSerializer valueSerializer = this.getValueSerializer();
        TypeSerializer namespaceSerializer = this.getNamespaceSerializer();
        switch (this.getStateType()) {
            case SUBKEYED_VALUE: {
                return new SubKeyedValueStateDescriptor(name, keySerializer, namespaceSerializer, valueSerializer);
            }
            case SUBKEYED_LIST: {
                TypeSerializer elementSerializer = ((ListSerializer)valueSerializer).getElementSerializer();
                return new SubKeyedListStateDescriptor(name, keySerializer, namespaceSerializer, elementSerializer);
            }
            case SUBKEYED_MAP: {
                return new SubKeyedMapStateDescriptor(name, keySerializer, namespaceSerializer, (MapSerializer)valueSerializer);
            }
            case SUBKEYED_SORTEDMAP: {
                return new SubKeyedSortedMapStateDescriptor(name, keySerializer, namespaceSerializer, (SortedMapSerializer)valueSerializer);
            }
        }
        throw new IllegalStateException("Unknown internal state type for " + (Object)((Object)this.getStateType()));
    }
}

