/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.net.URI;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.FutureUtil;
import org.apache.flink.util.LambdaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StateUtil.class);

    private StateUtil() {
        throw new AssertionError();
    }

    public static long getStateSize(StateObject handle) {
        return handle == null ? 0L : handle.getStateSize();
    }

    public static void bestEffortDiscardAllStateObjects(Iterable<? extends StateObject> handlesToDiscard) throws Exception {
        LambdaUtil.applyToAllWhileSuppressingExceptions(handlesToDiscard, StateObject::discardState);
    }

    public static void bestEffortDiscardAllPaths(Iterable<? extends Path> pathsToDiscard) throws Exception {
        LambdaUtil.applyToAllWhileSuppressingExceptions(pathsToDiscard, filePath -> FileSystem.get((URI)filePath.toUri()).delete(filePath, false));
    }

    public static void discardStateFuture(RunnableFuture<? extends StateObject> stateFuture) throws Exception {
        if (null != stateFuture && !stateFuture.cancel(true)) {
            try {
                StateObject stateObject = (StateObject)FutureUtil.runIfNotDoneAndGet(stateFuture);
                if (null != stateObject) {
                    stateObject.discardState();
                }
            }
            catch (CancellationException | ExecutionException ex) {
                LOG.debug("Cancelled execution of snapshot future runnable. Cancellation produced the following exception, which is expected an can be ignored.", (Throwable)ex);
            }
        }
    }
}

