/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.Collection;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.context.ContextKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.util.Preconditions;

public class ContextAggregatingState<K, IN, ACC, OUT>
implements ContextKeyedState<K, ACC>,
InternalAggregatingState<K, VoidNamespace, IN, ACC, OUT> {
    private final KeyContextImpl<K> keyContext;
    private final KeyedValueState<Object, ACC> keyedState;
    private final AggregateTransformation transformation;

    public ContextAggregatingState(KeyContextImpl<K> keyContext, KeyedValueState<Object, ACC> keyedState, AggregateFunction<IN, ACC, OUT> aggregateFunction) {
        Preconditions.checkNotNull(keyContext);
        Preconditions.checkNotNull(keyedState);
        Preconditions.checkNotNull(aggregateFunction);
        this.keyContext = keyContext;
        this.keyedState = keyedState;
        this.transformation = new AggregateTransformation(aggregateFunction);
    }

    public OUT get() {
        Object accumulator = this.keyedState.get(this.keyContext.getCurrentKey());
        return (OUT)(accumulator == null ? null : this.transformation.aggregateFunction.getResult(accumulator));
    }

    public void add(IN value) {
        this.keyedState.transform(this.keyContext.getCurrentKey(), value, this.transformation);
    }

    public void clear() {
        this.keyedState.remove(this.keyContext.getCurrentKey());
    }

    @Override
    public void mergeNamespaces(VoidNamespace target, Collection<VoidNamespace> sources) throws Exception {
        throw new UnsupportedOperationException("mergeNamespaces should not be called within keyed state.");
    }

    @Override
    public KeyedState getKeyedState() {
        return this.keyedState;
    }

    @Override
    public TypeSerializer getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<ACC> getValueSerializer() {
        return this.keyedState.getDescriptor().getValueSerializer();
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer safeKeySerializer, TypeSerializer safeNamespaceSerializer, TypeSerializer safeValueSerializer) throws Exception {
        return this.keyedState.getSerializedValue(serializedKeyAndNamespace, (TypeSerializer<Object>)safeKeySerializer, safeValueSerializer);
    }

    private class AggregateTransformation
    implements StateTransformationFunction<ACC, IN> {
        private final AggregateFunction<IN, ACC, OUT> aggregateFunction;

        public AggregateTransformation(AggregateFunction<IN, ACC, OUT> aggregateFunction) {
            this.aggregateFunction = (AggregateFunction)Preconditions.checkNotNull(aggregateFunction);
        }

        @Override
        public ACC apply(ACC accumulator, IN value) {
            if (accumulator == null) {
                accumulator = this.aggregateFunction.createAccumulator();
            }
            return this.aggregateFunction.add(value, accumulator);
        }
    }
}

