/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.context.ContextKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalFoldingState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.util.Preconditions;

public class ContextFoldingState<K, T, ACC>
implements ContextKeyedState<K, ACC>,
InternalFoldingState<K, VoidNamespace, T, ACC> {
    private final KeyContextImpl<K> keyContext;
    private final KeyedValueState<Object, ACC> keyedState;
    private final FoldingStateDescriptor<T, ACC> stateDescriptor;
    private final FoldTransformation foldTransformation;

    public ContextFoldingState(KeyContextImpl<K> keyContext, KeyedValueState<Object, ACC> keyedState, FoldingStateDescriptor<T, ACC> stateDescriptor) {
        Preconditions.checkNotNull(keyContext);
        Preconditions.checkNotNull(keyedState);
        Preconditions.checkNotNull(stateDescriptor);
        this.keyContext = keyContext;
        this.keyedState = keyedState;
        this.stateDescriptor = stateDescriptor;
        this.foldTransformation = new FoldTransformation(stateDescriptor.getFoldFunction());
    }

    public ACC get() {
        return (ACC)this.keyedState.get(this.keyContext.getCurrentKey());
    }

    public void add(T value) {
        this.keyedState.transform(this.keyContext.getCurrentKey(), value, this.foldTransformation);
    }

    public void clear() {
        this.keyedState.remove(this.keyContext.getCurrentKey());
    }

    private ACC getInitialValue() {
        return (ACC)this.stateDescriptor.getInitialValue();
    }

    @Override
    public KeyedState getKeyedState() {
        return this.keyedState;
    }

    @Override
    public TypeSerializer getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<ACC> getValueSerializer() {
        return this.keyedState.getDescriptor().getValueSerializer();
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer safeKeySerializer, TypeSerializer safeNamespaceSerializer, TypeSerializer safeValueSerializer) throws Exception {
        return this.keyedState.getSerializedValue(serializedKeyAndNamespace, (TypeSerializer<Object>)safeKeySerializer, safeValueSerializer);
    }

    private final class FoldTransformation
    implements StateTransformationFunction<ACC, T> {
        private final FoldFunction<T, ACC> foldFunction;

        FoldTransformation(FoldFunction<T, ACC> foldFunction) {
            this.foldFunction = (FoldFunction)Preconditions.checkNotNull(foldFunction);
        }

        @Override
        public ACC apply(ACC previousState, T value) throws Exception {
            return this.foldFunction.fold(previousState != null ? previousState : ContextFoldingState.this.getInitialValue(), value);
        }
    }
}

