/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.context.ContextKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.util.Preconditions;

public class ContextListState<K, E>
implements ContextKeyedState<K, List<E>>,
InternalListState<K, VoidNamespace, E> {
    private final KeyContextImpl<K> keyContext;
    private final KeyedListState<Object, E> keyedState;

    public ContextListState(KeyContextImpl<K> keyContext, KeyedListState<Object, E> keyedState) {
        Preconditions.checkNotNull(keyContext);
        Preconditions.checkNotNull(keyedState);
        this.keyContext = keyContext;
        this.keyedState = keyedState;
    }

    public Iterable<E> get() {
        return (Iterable)this.keyedState.get(this.keyContext.getCurrentKey());
    }

    public void add(E value) {
        this.keyedState.add(this.keyContext.getCurrentKey(), value);
    }

    public void clear() {
        this.keyedState.remove(this.keyContext.getCurrentKey());
    }

    @Override
    public void update(List<E> values) {
        Preconditions.checkNotNull(values, (String)"List of values to add cannot be null.");
        if (values.isEmpty()) {
            this.keyedState.remove(this.keyContext.getCurrentKey());
        } else {
            this.keyedState.putAll(this.keyContext.getCurrentKey(), values);
        }
    }

    @Override
    public void addAll(List<E> values) {
        Preconditions.checkNotNull(values, (String)"List of values to add cannot be null.");
        if (!values.isEmpty()) {
            this.keyedState.addAll(this.keyContext.getCurrentKey(), values);
        }
    }

    @Override
    public KeyedState<Object, List<E>> getKeyedState() {
        return this.keyedState;
    }

    @Override
    public void mergeNamespaces(VoidNamespace target, Collection<VoidNamespace> sources) throws Exception {
        throw new UnsupportedOperationException("mergeNamespaces should not be called.");
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<VoidNamespace> getNamespaceSerializer() {
        return VoidNamespaceSerializer.INSTANCE;
    }

    @Override
    public TypeSerializer<List<E>> getValueSerializer() {
        return this.keyedState.getDescriptor().getValueSerializer();
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer safeKeySerializer, TypeSerializer safeNamespaceSerializer, TypeSerializer safeValueSerializer) throws Exception {
        return this.keyedState.getSerializedValue(serializedKeyAndNamespace, (TypeSerializer<Object>)safeKeySerializer, safeValueSerializer);
    }
}

