/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.SortedMapState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.context.ContextKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapState;
import org.apache.flink.runtime.state.keyed.KeyedState;

public class ContextSortedMapState<K, UK, UV>
implements ContextKeyedState<K, Map<UK, UV>>,
SortedMapState<UK, UV>,
InternalMapState<K, VoidNamespace, UK, UV> {
    private final KeyContextImpl<K> keyContext;
    private final KeyedSortedMapState<Object, UK, UV> keyedState;

    public ContextSortedMapState(KeyContextImpl<K> keyContext, KeyedSortedMapState<Object, UK, UV> keyedState) {
        this.keyContext = keyContext;
        this.keyedState = keyedState;
    }

    public Map.Entry<UK, UV> firstEntry() {
        return this.keyedState.firstEntry(this.keyContext.getCurrentKey());
    }

    public Map.Entry<UK, UV> lastEntry() {
        return this.keyedState.lastEntry(this.keyContext.getCurrentKey());
    }

    public Iterator<Map.Entry<UK, UV>> headIterator(UK endKey) {
        return this.keyedState.headIterator(this.keyContext.getCurrentKey(), endKey);
    }

    public Iterator<Map.Entry<UK, UV>> tailIterator(UK startKey) {
        return this.keyedState.tailIterator(this.keyContext.getCurrentKey(), startKey);
    }

    public Iterator<Map.Entry<UK, UV>> subIterator(UK startKey, UK endKey) {
        return this.keyedState.subIterator(this.keyContext.getCurrentKey(), startKey, endKey);
    }

    public boolean contains(UK key) {
        return this.keyedState.contains(this.keyContext.getCurrentKey(), key);
    }

    public UV get(UK key) {
        return (UV)this.keyedState.get(this.keyContext.getCurrentKey(), key);
    }

    public void put(UK key, UV value) {
        this.keyedState.add(this.keyContext.getCurrentKey(), key, value);
    }

    public void putAll(Map<UK, UV> map) {
        this.keyedState.addAll(this.keyContext.getCurrentKey(), map);
    }

    public void remove(UK key) {
        this.keyedState.remove(this.keyContext.getCurrentKey(), key);
    }

    public Iterable<Map.Entry<UK, UV>> entries() {
        return this::iterator;
    }

    public Iterable<UK> keys() {
        return () -> {
            final Iterator<Map.Entry<UK, UV>> entryIterator = this.iterator();
            return new Iterator<UK>(){

                @Override
                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                @Override
                public UK next() {
                    Map.Entry entry = (Map.Entry)entryIterator.next();
                    return entry.getKey();
                }
            };
        };
    }

    public Iterable<UV> values() {
        return () -> {
            final Iterator<Map.Entry<UK, UV>> entryIterator = this.iterator();
            return new Iterator<UV>(){

                @Override
                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                @Override
                public UV next() {
                    Map.Entry entry = (Map.Entry)entryIterator.next();
                    return entry.getValue();
                }
            };
        };
    }

    public Iterator<Map.Entry<UK, UV>> iterator() {
        return this.keyedState.iterator(this.keyContext.getCurrentKey());
    }

    public void clear() {
        this.keyedState.remove(this.keyContext.getCurrentKey());
    }

    @Override
    public KeyedState getKeyedState() {
        return this.keyedState;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<Map<UK, UV>> getValueSerializer() {
        return this.keyedState.getDescriptor().getValueSerializer();
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer safeKeySerializer, TypeSerializer safeNamespaceSerializer, TypeSerializer safeValueSerializer) throws Exception {
        return this.keyedState.getSerializedValue(serializedKeyAndNamespace, safeKeySerializer, safeValueSerializer);
    }
}

