/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.Collection;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.context.ContextSubKeyedAppendingState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.util.Preconditions;

public class ContextSubKeyedReducingState<K, N, T>
implements ContextSubKeyedAppendingState<K, N, T, T, T>,
InternalReducingState<K, N, T> {
    private N namespace;
    private final KeyContextImpl<K> operator;
    private final SubKeyedValueState<Object, N, T> subKeyedValueState;
    private final ReduceTransformation transformation;

    public ContextSubKeyedReducingState(KeyContextImpl<K> operator, SubKeyedValueState<Object, N, T> subKeyedValueState, ReduceFunction<T> reduceFunction) {
        Preconditions.checkNotNull(operator);
        Preconditions.checkNotNull(subKeyedValueState);
        Preconditions.checkNotNull(reduceFunction);
        this.operator = operator;
        this.subKeyedValueState = subKeyedValueState;
        this.transformation = new ReduceTransformation(reduceFunction);
    }

    public T get() {
        return (T)this.subKeyedValueState.get(this.getCurrentKey(), this.namespace);
    }

    public void add(T value) {
        this.subKeyedValueState.transform(this.operator.getCurrentKey(), this.namespace, value, this.transformation);
    }

    public void clear() {
        this.subKeyedValueState.remove(this.getCurrentKey(), this.namespace);
    }

    private Object getCurrentKey() {
        return this.operator.getCurrentKey();
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        Object currentKey = this.getCurrentKey();
        Object merged = null;
        for (N source : sources) {
            T sourceState = this.subKeyedValueState.getAndRemove(currentKey, source);
            if (merged != null && sourceState != null) {
                merged = this.transformation.reduceFunction.reduce(merged, sourceState);
                continue;
            }
            if (merged != null) continue;
            merged = sourceState;
        }
        if (merged != null) {
            this.subKeyedValueState.transform(currentKey, target, merged, this.transformation);
        }
    }

    @Override
    public SubKeyedState getSubKeyedState() {
        return this.subKeyedValueState;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.operator.getKeySerializer();
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.subKeyedValueState.getDescriptor().getNamespaceSerializer();
    }

    @Override
    public TypeSerializer getValueSerializer() {
        return this.subKeyedValueState.getDescriptor().getValueSerializer();
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.namespace = namespace;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<T> safeValueSerializer) throws Exception {
        return new byte[0];
    }

    private class ReduceTransformation
    implements StateTransformationFunction<T, T> {
        private final ReduceFunction<T> reduceFunction;

        public ReduceTransformation(ReduceFunction<T> reduceFunction) {
            this.reduceFunction = (ReduceFunction)Preconditions.checkNotNull(reduceFunction);
        }

        @Override
        public T apply(T previousState, T value) throws Exception {
            return previousState == null ? value : this.reduceFunction.reduce(previousState, value);
        }
    }
}

