/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.context.ContextSubKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.util.Preconditions;

public class ContextSubKeyedValueState<K, N, V>
implements ContextSubKeyedState<K, N, V>,
InternalValueState<K, N, V> {
    private N namespace;
    private final KeyContextImpl<K> keyContext;
    private final SubKeyedValueState<K, N, V> subKeyedValueState;
    private final V defaultValue;

    public ContextSubKeyedValueState(KeyContextImpl<K> keyContext, SubKeyedValueState<K, N, V> subKeyedValueState, V defaultValue) {
        Preconditions.checkNotNull(keyContext);
        Preconditions.checkNotNull(subKeyedValueState);
        this.keyContext = keyContext;
        this.subKeyedValueState = subKeyedValueState;
        this.defaultValue = defaultValue;
    }

    public V value() throws IOException {
        Object value = this.subKeyedValueState.get(this.keyContext.getCurrentKey(), this.namespace);
        return value == null ? this.defaultValue : value;
    }

    public void update(V value) throws IOException {
        this.subKeyedValueState.put(this.keyContext.getCurrentKey(), this.namespace, value);
    }

    public void clear() {
        this.subKeyedValueState.remove(this.keyContext.getCurrentKey(), this.namespace);
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.subKeyedValueState.getDescriptor().getNamespaceSerializer();
    }

    @Override
    public TypeSerializer<V> getValueSerializer() {
        return this.subKeyedValueState.getDescriptor().getValueSerializer();
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.namespace = namespace;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        return this.subKeyedValueState.getSerializedValue(serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer, safeValueSerializer);
    }

    @Override
    public SubKeyedState getSubKeyedState() {
        return this.subKeyedValueState;
    }
}

