/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.state.StateBackendFactory;
import org.apache.flink.runtime.state.gemini.GeminiStateBackend;

@PublicEvolving
public class GeminiStateBackendFactory
implements StateBackendFactory<GeminiStateBackend> {
    @Override
    public GeminiStateBackend createFromConfig(Configuration config) throws IllegalConfigurationException, IOException {
        String checkpointDirURI = config.getString(CheckpointingOptions.CHECKPOINTS_DIRECTORY);
        if (checkpointDirURI == null) {
            throw new IllegalConfigurationException("Cannot create the RocksDB state backend: The configuration does not specify the checkpoint directory '" + CheckpointingOptions.CHECKPOINTS_DIRECTORY.key() + '\'');
        }
        return new GeminiStateBackend(checkpointDirURI).configure(config);
    }
}

