/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import java.io.IOException;
import org.apache.flink.runtime.state.gemini.engine.ExceptionStat;
import org.apache.flink.runtime.state.gemini.engine.fs.FileID;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiOutputStream;
import org.apache.flink.util.Preconditions;

public class FTFileWriter
extends FileWriter {
    private final FileManager fileManager;
    private final FileID fileID;
    private final String filePath;
    private int continuesFailCount = 0;
    private final int failCountThreshold;
    private final ExceptionStat exceptionStat;
    private final Object lock = new Object();
    private volatile boolean closed;

    public FTFileWriter(GeminiOutputStream geminiOutputStream, FileManager fileManager, FileID fileID, String filePath, int failCountThread, ExceptionStat exceptionStat) {
        super(geminiOutputStream);
        this.fileManager = (FileManager)Preconditions.checkNotNull((Object)fileManager);
        this.fileID = (FileID)Preconditions.checkNotNull((Object)fileID);
        this.filePath = (String)Preconditions.checkNotNull((Object)filePath);
        this.failCountThreshold = failCountThread;
        this.exceptionStat = exceptionStat;
    }

    @Override
    public long getAddress() throws IOException {
        return this.fileManager.getAddress(this.fileID, this.getPos());
    }

    @Override
    public long getSize() throws IOException {
        return this.getPos();
    }

    @Override
    public FileID getFileID() {
        return this.fileID;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void increasFailCount() {
        ++this.continuesFailCount;
        this.exceptionStat.addTotalWriterException(1);
    }

    @Override
    public void resetFailCount() {
        this.continuesFailCount = 0;
    }

    @Override
    public boolean isValid() {
        return this.continuesFailCount < this.failCountThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                super.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        if (!this.closed) {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                super.sync();
            }
        }
    }

    public String toString() {
        return "FileWriterImpl: {fileID=" + this.fileID + ", filePath=" + this.filePath + "}";
    }
}

