/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.gemini.GeminiOptions;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparatorType;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.util.Preconditions;

public class GConfiguration {
    private long fileCacheCapacity;
    private String dfsPath;
    private String localPath;
    private int metricSampleCount;
    private int metricHistogramWindowSize;
    private int flushThreadNum;
    private int snapshotThreadNum;
    private int regionThreadNum;
    private int compactionThreadNum;
    private long maxLogStructureFileSize;
    private long writeBufferSize;
    private int maxCompactionThreshold;
    private int inMemoryCompactionThreshold;
    private int maxRunningMajorCompaction;
    private int maxRunningMinorCompaction;
    private boolean useOffheap;
    private boolean forceReadUseOffheap;
    private float totalWriteBufferRate;
    private int totalReadPageLRUNum;
    private float heapRate;
    private int numFlushingSegment;
    private float totalNumFlushingSegmentRatio;
    private int bucketNum;
    private int spillHighWaterMark;
    private int spillLowWaterMark;
    private int spillMiddleWaterMark;
    private long ttl;
    private GComparatorType comparatorType = GComparatorType.bytes;
    private int subTaskIndex;
    private int numParallelSubtasks;
    private String backendUID;
    private int fileCleanThreadNum;
    private long fileCleanInterval;
    private long fileAliveTimeAfterNoDataReference;
    private long fileDeletionCheckInterval;
    private int dbNumberPerJVM = 1;
    private long totalHeapMemSize;
    private long totalOffheapMemSize;
    private boolean readCopy;
    private boolean writeCopy;
    private int writerFailCountThreshold;
    private int fileManagerFailCountThreshold;
    private int fileManagerCreateFileWriterRetryInterval;
    private boolean localSnapshotEnabled;
    private long preFetchThreadSleepTimeNs;
    private long commonThreadSleepTimeNs;
    private GCompressAlgorithm inPageCompressAlgorithm;
    private GCompressAlgorithm flushWholePageCompressAlgorithm;
    private boolean prefetchEnable = true;
    private int allocatorDirectArena;
    private int logicTableDefaultChainLen;
    private float totalHeapLowMarkRate;
    private float totalHeapMiddleMarkRate;
    private float totalHeapHighMarkRate;
    private float pageSizeRateBetweenPOJOAndHeap;
    private float totalPOJOPageUsedRate;
    private long totalIndexCountHighMark;
    private long totalIndexCountLowMark;
    private boolean checksumEnable;
    private String operatorNameWithSubtask = "";
    private int batchSortCount;

    public GConfiguration() {
    }

    public GConfiguration(Configuration configuration) {
        this.load(configuration);
    }

    public void setLogicTableDefaultChainLen(int logicTableDefaultChainLen) {
        this.logicTableDefaultChainLen = logicTableDefaultChainLen;
    }

    public int getLogicTableDefaultChainLen() {
        return this.logicTableDefaultChainLen;
    }

    public int getPageIndexBucketLenDefault() {
        return this.bucketNum;
    }

    public void setPageIndexBucketLenDefault(int bucketNum) {
        this.bucketNum = bucketNum;
    }

    public float getTotalWriteBufferRate() {
        return this.totalWriteBufferRate;
    }

    public int getTotalReadPageLRUNum() {
        return this.totalReadPageLRUNum;
    }

    public float getTotalHeapRate() {
        return this.heapRate;
    }

    public void setTotalHeapRate(float heapRate) {
        this.heapRate = heapRate;
    }

    public void setTotalHeapLowMarkRate(float totalHeapLowMarkRate) {
        this.totalHeapLowMarkRate = totalHeapLowMarkRate;
    }

    public float getTotalHeapLowMarkRate() {
        return this.totalHeapLowMarkRate;
    }

    public void setTotalHeapMiddleMarkRate(float totalHeapMiddleMarkRate) {
        this.totalHeapMiddleMarkRate = totalHeapMiddleMarkRate;
    }

    public float getTotalHeapMiddleMarkRate() {
        return this.totalHeapMiddleMarkRate;
    }

    public void setTotalHeapHighMarkRate(float totalHeapHighMarkRate) {
        this.totalHeapHighMarkRate = totalHeapHighMarkRate;
    }

    public float getTotalHeapHighMarkRate() {
        return this.totalHeapHighMarkRate;
    }

    public void setPageSizeRateBetweenPOJOAndHeap(float pageSizeRateBetweenPOJOAndHeap) {
        this.pageSizeRateBetweenPOJOAndHeap = pageSizeRateBetweenPOJOAndHeap;
    }

    public float getPageSizeRateBetweenPOJOAndHeap() {
        return this.pageSizeRateBetweenPOJOAndHeap;
    }

    public void setTotalPOJOPageUsedRate(float pojoPageUsedRate) {
        this.totalPOJOPageUsedRate = pojoPageUsedRate;
    }

    public float getTotalPOJOPageUsedRate() {
        return this.totalPOJOPageUsedRate;
    }

    public int getSpilledPageSizeThresholdUnderHighMark() {
        return this.spillHighWaterMark;
    }

    public int getSpilledPageSizeThresholdUnderLowMark() {
        return this.spillLowWaterMark;
    }

    public int getSpilledPageSizeThresholdUnderMiddleMark() {
        return this.spillMiddleWaterMark;
    }

    public long getWriteBufferWaterMark() {
        return this.writeBufferSize;
    }

    public void setWriteBUfferWaterMark(long writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public void setTotalIndexCountHighMark(long totalIndexCountHighMark) {
        this.totalIndexCountHighMark = totalIndexCountHighMark;
    }

    public long getTotalIndexCountHighMark() {
        return this.totalIndexCountHighMark;
    }

    public void setTotalIndexCountLowMark(long totalIndexCountLowMark) {
        this.totalIndexCountLowMark = totalIndexCountLowMark;
    }

    public long getTotalIndexCountLowMark() {
        return this.totalIndexCountLowMark;
    }

    public int getMaxCompactionChainThreshold() {
        return this.maxCompactionThreshold;
    }

    public void setDfsPath(String dfsPath) {
        this.dfsPath = (String)Preconditions.checkNotNull((Object)dfsPath);
    }

    public String getDfsPath() {
        return this.dfsPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = (String)Preconditions.checkNotNull((Object)localPath);
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setMetricSampleCount(int count) {
        this.metricSampleCount = count;
    }

    public int getMetricSampleCount() {
        return this.metricSampleCount;
    }

    public void setMetricHistogramWindowSize(int metricHistogramWindowSize) {
        this.metricHistogramWindowSize = metricHistogramWindowSize;
    }

    public String getBackendUID() {
        return this.backendUID;
    }

    public void setBackendUID(String backendUID) {
        this.backendUID = backendUID;
    }

    public void setFlushThreadNum(int flushThreadNum) {
        this.flushThreadNum = flushThreadNum;
    }

    public int getFlushThreadNum() {
        return this.flushThreadNum;
    }

    public int getSnapshotThreadNum() {
        return this.snapshotThreadNum;
    }

    public void setSnapshotThreadNum(int snapshotThreadNum) {
        this.snapshotThreadNum = snapshotThreadNum;
    }

    public void setRegionThreadNum(int regionThreadNum) {
        this.regionThreadNum = regionThreadNum;
    }

    public int getRegionThreadNum() {
        return this.regionThreadNum;
    }

    public int getMetricHistogramWindowSize() {
        return this.metricHistogramWindowSize;
    }

    public void setMaxLogStructureFileSize(long maxLogStructureFileSize) {
        this.maxLogStructureFileSize = maxLogStructureFileSize;
    }

    public long getMaxLogStructureFileSize() {
        return this.maxLogStructureFileSize;
    }

    public int getInMemoryCompactionThreshold() {
        return this.inMemoryCompactionThreshold;
    }

    public int getMaxRunningMajorCompaction() {
        return this.maxRunningMajorCompaction;
    }

    public int getMaxRunningMinorCompaction() {
        return this.maxRunningMinorCompaction;
    }

    public void setInMemoryCompactionThreshold(int threshold) {
        this.inMemoryCompactionThreshold = threshold;
    }

    public void setUseOffheap() {
        this.useOffheap = true;
    }

    public boolean getUseOffheap() {
        return this.useOffheap;
    }

    public boolean getForceReadUseOffheap() {
        return this.forceReadUseOffheap;
    }

    public int getNumFlushingSegment() {
        return this.numFlushingSegment;
    }

    public float getTotalNumFlushingSegmentRatio() {
        return this.totalNumFlushingSegmentRatio;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public long getTtl() {
        return this.ttl;
    }

    public GComparatorType getComparatorType() {
        return this.comparatorType;
    }

    public void setSubTaskIndex(int subTaskIndex) {
        this.subTaskIndex = subTaskIndex;
    }

    public void setNumParallelSubtasks(int numParallelSubtasks) {
        this.numParallelSubtasks = numParallelSubtasks;
    }

    public int getSubTaskIndex() {
        return this.subTaskIndex;
    }

    public int getNumParallelSubtasks() {
        return this.numParallelSubtasks;
    }

    public long getFileCacheCapacity() {
        return this.fileCacheCapacity;
    }

    public void setFileCacheCapacity(long fileCacheCapacity) {
        this.fileCacheCapacity = fileCacheCapacity;
    }

    public void setFileCleanThreadNum(int threadNum) {
        this.fileCleanThreadNum = threadNum;
    }

    public int getFileCleanThreadNum() {
        return this.fileCleanThreadNum;
    }

    public void setFileCleanInterval(long interval) {
        this.fileCleanInterval = interval;
    }

    public long getFileCleanInterval() {
        return this.fileCleanInterval;
    }

    public void setFileAliveTimeAfterNoDataReference(long aliveTime) {
        this.fileAliveTimeAfterNoDataReference = aliveTime;
    }

    public long getFileAliveTimeAfterNoDataReference() {
        return this.fileAliveTimeAfterNoDataReference;
    }

    public void setFileDeletionCheckInterval(long interval) {
        this.fileDeletionCheckInterval = interval;
    }

    public long getFileDeletionCheckInterval() {
        return this.fileDeletionCheckInterval;
    }

    public boolean isReadCopy() {
        return this.readCopy;
    }

    public boolean isWriteCopy() {
        return this.writeCopy;
    }

    public int getWriterFailCountThreshold() {
        return this.writerFailCountThreshold;
    }

    public void setWriterFailCountThreshold(int writerFailCountThreshold) {
        this.writerFailCountThreshold = writerFailCountThreshold;
    }

    public int getFileManagerFailCountThreshold() {
        return this.fileManagerFailCountThreshold;
    }

    public void setFileManagerFailCountThreshold(int fileManagerFailCountThreshold) {
        this.fileManagerFailCountThreshold = fileManagerFailCountThreshold;
    }

    public int getFileManagerCreateFileWriterRetryInterval() {
        return this.fileManagerCreateFileWriterRetryInterval;
    }

    public void setFileManagerCreateFileWriterRetryInterval(int fileManagerCreateFileWriterRetryInterval) {
        this.fileManagerCreateFileWriterRetryInterval = fileManagerCreateFileWriterRetryInterval;
    }

    private void load(Configuration configuration) {
        this.metricSampleCount = configuration.getInteger(GeminiOptions.SAMPLE_COUNT);
        this.metricHistogramWindowSize = configuration.getInteger(GeminiOptions.HISTOGRAM_WINDOW_SIZE);
        this.flushThreadNum = configuration.getInteger(GeminiOptions.FLUSH_THREAD_NUM);
        this.snapshotThreadNum = configuration.getInteger(GeminiOptions.SNAPSHOT_THREAD_NUM);
        this.regionThreadNum = configuration.getInteger(GeminiOptions.REGION_THREAD_NUM);
        this.maxLogStructureFileSize = configuration.getLong(GeminiOptions.MAX_LOG_STRUCTURE_FILE_SIZE);
        this.writeBufferSize = configuration.getLong(GeminiOptions.GEMINIDB_WRITE_BUFFER_SIZE);
        this.compactionThreadNum = configuration.getInteger(GeminiOptions.COMPACTION_THREAD_NUM);
        this.maxCompactionThreshold = configuration.getInteger(GeminiOptions.GEMINIDB_MAX_COMPACTION_THRESHOLD);
        this.inMemoryCompactionThreshold = configuration.getInteger(GeminiOptions.GEMINIDB_IN_MEMORY_COMPACTION_THRESHOLD);
        this.maxRunningMajorCompaction = configuration.getInteger(GeminiOptions.GEMINIDB_MAX_RUNNING_MAJOR_COMPACTION_THRESHOLD);
        this.maxRunningMinorCompaction = configuration.getInteger(GeminiOptions.GEMINIDB_MAX_RUNNING_MINOR_COMPACTION_THRESHOLD);
        this.useOffheap = configuration.getBoolean(GeminiOptions.GEMINIDB_OFFHEAP_MEMORY);
        this.forceReadUseOffheap = configuration.getBoolean(GeminiOptions.GEMINIDB_FORCE_READ_OFFHEAP_MEMORY);
        this.totalWriteBufferRate = configuration.getFloat(GeminiOptions.GEMINIDB_TOTAL_WRITEBUFFER_RATE);
        this.totalReadPageLRUNum = configuration.getInteger(GeminiOptions.GEMINIDB_TOTAL_READPAGELRU_NUM);
        this.heapRate = configuration.getFloat(GeminiOptions.GEMINIDB_HEAP_RATE);
        this.numFlushingSegment = configuration.getInteger(GeminiOptions.GEMINIDB_FLUSING_SEGMENT);
        this.totalNumFlushingSegmentRatio = configuration.getFloat(GeminiOptions.GEMINIDB_FLUSING_SEGMENT_RATIO);
        this.bucketNum = configuration.getInteger(GeminiOptions.GEMINIDB_BUCKET_NUM);
        this.spillHighWaterMark = configuration.getInteger(GeminiOptions.GEMINIDB_SPILL_HIGH_WATERMARK);
        this.spillLowWaterMark = configuration.getInteger(GeminiOptions.GEMINIDB_SPILL_LOW_WATERMARK);
        this.spillMiddleWaterMark = configuration.getInteger(GeminiOptions.GEMINIDB_SPILL_MIDDLE_WATERMARK);
        this.ttl = configuration.getLong(GeminiOptions.GEMINIDB_TTL);
        this.fileCacheCapacity = configuration.getLong(GeminiOptions.FILE_CACHE_CAPACITY);
        this.fileCleanInterval = configuration.getLong(GeminiOptions.FILE_CLEAN_INTERVAL);
        this.fileCleanThreadNum = configuration.getInteger(GeminiOptions.FILE_CLEAN_THREAD_NUM);
        this.fileAliveTimeAfterNoDataReference = configuration.getLong(GeminiOptions.FILE_ALIVE_TIME_AFTER_NO_DATA_REFERENCE);
        this.fileDeletionCheckInterval = configuration.getLong(GeminiOptions.FILE_DELETION_CHECK_INTERVAL);
        this.comparatorType = GComparatorType.getComparatorType(configuration.getString(GeminiOptions.GEMINI_COMPARATOR_TYPE));
        this.readCopy = configuration.getBoolean(GeminiOptions.READ_COPY);
        this.writeCopy = configuration.getBoolean(GeminiOptions.WRITE_COPY);
        this.writerFailCountThreshold = configuration.getInteger(GeminiOptions.WRITER_FAILCOUNT_THESHOLD);
        this.fileManagerFailCountThreshold = configuration.getInteger(GeminiOptions.FILEMANAGER_FAILCOUNT_THESHOLD);
        this.fileManagerCreateFileWriterRetryInterval = configuration.getInteger(GeminiOptions.FILEMANAGER_RETRY_INTERVAL);
        this.preFetchThreadSleepTimeNs = configuration.getLong(GeminiOptions.PREFETCH_THREAD_SLEEP_TIME_NS);
        this.commonThreadSleepTimeNs = configuration.getLong(GeminiOptions.COMMON_THREAD_SLEEP_TIME_NS);
        this.flushWholePageCompressAlgorithm = GCompressAlgorithm.None;
        this.inPageCompressAlgorithm = GCompressAlgorithm.valueOf(configuration.getString(GeminiOptions.IN_PAGE_COMPRESSION)) != GCompressAlgorithm.None ? GCompressAlgorithm.Lz4 : GCompressAlgorithm.None;
        this.prefetchEnable = configuration.getBoolean(GeminiOptions.PREFETCH_ENABLE);
        this.allocatorDirectArena = configuration.getInteger(GeminiOptions.ALLOCATOR_DIRECT_ARENA);
        this.logicTableDefaultChainLen = configuration.getInteger(GeminiOptions.LOGIC_CHAIN_INIT_LEN);
        this.totalHeapLowMarkRate = configuration.getFloat(GeminiOptions.TOTAL_HEAP_LOW_MARK_RATE);
        this.totalHeapMiddleMarkRate = configuration.getFloat(GeminiOptions.TOTAL_HEAP_MIDDLE_MARK_RATE);
        this.totalHeapHighMarkRate = configuration.getFloat(GeminiOptions.TOTAL_HEAP_HIGH_MARK_RATE);
        this.pageSizeRateBetweenPOJOAndHeap = configuration.getFloat(GeminiOptions.PAGE_SIZE_RATE_BETWEEN_POJO_HEAP);
        this.totalPOJOPageUsedRate = configuration.getFloat(GeminiOptions.TOTAL_POJO_PAGE_USED_RATE);
        this.totalIndexCountHighMark = configuration.getInteger(GeminiOptions.INDEX_COUNT_HIGH_MARK);
        this.totalIndexCountLowMark = configuration.getInteger(GeminiOptions.INDEX_COUNT_LOW_MARK);
        this.checksumEnable = configuration.getBoolean(GeminiOptions.CHECKSUM_ENABLE);
        this.batchSortCount = configuration.getInteger(GeminiOptions.BATCH_SORT_COUNT);
        this.updateTotalHeapMemSize();
        this.updateTotalOffHeapMemSize();
    }

    public int getCompactionThreadNum() {
        return this.compactionThreadNum;
    }

    public void setDBNumberPerJVM(int dbNumberPerJVM) {
        if (dbNumberPerJVM <= 1) {
            dbNumberPerJVM = 1;
        }
        this.dbNumberPerJVM = dbNumberPerJVM;
        this.updateTotalHeapMemSize();
        this.updateTotalOffHeapMemSize();
    }

    public int getDBNumberPerJVM() {
        return this.dbNumberPerJVM;
    }

    private void updateTotalHeapMemSize() {
        this.totalHeapMemSize = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() / (long)this.dbNumberPerJVM;
    }

    public long getTotalHeapMemSize() {
        return this.totalHeapMemSize;
    }

    private void updateTotalOffHeapMemSize() {
        this.totalOffheapMemSize = GConfiguration.getDirectMemorySize() / (long)this.dbNumberPerJVM;
    }

    public long getTotalOffheapMemSize() {
        return this.totalOffheapMemSize;
    }

    private static long getDirectMemorySize() {
        try {
            Class<?> c = Class.forName("java.nio.Bits");
            Field maxMemory = c.getDeclaredField("maxMemory");
            maxMemory.setAccessible(true);
            Field reservedMemory = c.getDeclaredField("reservedMemory");
            reservedMemory.setAccessible(true);
            return (Long)maxMemory.get(null);
        }
        catch (Exception e) {
            throw new GeminiRuntimeException(e);
        }
    }

    public void setLocalSnapshot(boolean enableLocalSnapshot) {
        this.localSnapshotEnabled = enableLocalSnapshot;
    }

    public boolean isLocalSnapshotEnabled() {
        return this.localSnapshotEnabled;
    }

    public long getFetchThreadSleepTimeNS() {
        return this.preFetchThreadSleepTimeNs;
    }

    public long getCommonThreadSleepTimeNs() {
        return this.commonThreadSleepTimeNs;
    }

    public GCompressAlgorithm getInPageGCompressAlgorithm() {
        return this.inPageCompressAlgorithm;
    }

    public GCompressAlgorithm getFlushWholePageGCompressAlgorithm() {
        return this.flushWholePageCompressAlgorithm;
    }

    public boolean getEnablePrefetch() {
        return this.prefetchEnable;
    }

    public int getAllocatorDirectArena() {
        return this.allocatorDirectArena;
    }

    public boolean isChecksumEnable() {
        return this.checksumEnable;
    }

    public void setOperatorNameWithSubtask(String operatorNameWithSubtask) {
        this.operatorNameWithSubtask = operatorNameWithSubtask;
    }

    public String getOperatorNameWithSubtask() {
        return this.operatorNameWithSubtask;
    }

    public String getExcetorPrefixName() {
        return this.operatorNameWithSubtask == null || this.operatorNameWithSubtask.isEmpty() ? "" : this.operatorNameWithSubtask + "-";
    }

    public int getBatchSortCount() {
        return this.batchSortCount;
    }
}

