/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferStats;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreStats;
import org.apache.flink.runtime.state.gemini.engine.utils.SeqIDUtils;

public class GRegionContext {
    private final String tableName;
    private final GRegionID regionId;
    private final WriteBufferStats writeBufferStats;
    private final PageStoreStats pageStoreStats;
    private GContext gContext;
    private long writeBufferWaterMark;
    private final PageSerdeFlink pageSerdeFlink;
    private volatile long lastSeqID;
    private volatile long removeAllSeqID;

    public GRegionContext(GContext gContext, String tableName, GRegionID regionId, PageSerdeFlink pageSerdeFlink) {
        this(gContext, tableName, regionId, pageSerdeFlink, 0L, 0L);
    }

    public GRegionContext(GContext gContext, String tableName, GRegionID regionId, PageSerdeFlink pageSerdeFlink, long lastSeqID, long removeAllSeqID) {
        this.tableName = tableName;
        this.gContext = gContext;
        this.pageStoreStats = new PageStoreStats(tableName + regionId, gContext.getSupervisor().getCacheManager());
        this.regionId = regionId;
        this.pageSerdeFlink = pageSerdeFlink;
        this.writeBufferWaterMark = gContext.getGConfiguration().getWriteBufferWaterMark();
        this.lastSeqID = lastSeqID;
        this.removeAllSeqID = removeAllSeqID;
        this.writeBufferStats = new WriteBufferStats(gContext.getSupervisor().getWriteBufferManager());
    }

    public WriteBufferStats getWriteBufferStats() {
        return this.writeBufferStats;
    }

    public PageStoreStats getPageStoreStats() {
        return this.pageStoreStats;
    }

    public GContext getGContext() {
        return this.gContext;
    }

    public void setWriteBufferWaterMark(long writeBufferWaterMark) {
        this.writeBufferWaterMark = writeBufferWaterMark;
    }

    public long getWriteBufferWaterMark() {
        return this.writeBufferWaterMark;
    }

    public PageSerdeFlink getPageSerdeFlink() {
        return this.pageSerdeFlink;
    }

    public GRegionID getRegionId() {
        return this.regionId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getLastSeqID() {
        return this.lastSeqID;
    }

    public long getNextSeqID() {
        long ts = this.gContext.getTimeProvider().currentTimestamp();
        this.lastSeqID = SeqIDUtils.nextSeqID(this.lastSeqID, ts);
        return this.lastSeqID;
    }

    public void setRemoveAllSeqID(long removeAllSeqID) {
        this.removeAllSeqID = removeAllSeqID;
    }

    public long getRemoveAllSeqID() {
        return this.removeAllSeqID;
    }

    public boolean filterState(long seqID) {
        StateFilter stateFilter = this.gContext.getStateFilter();
        return stateFilter != null && this.gContext.getStateFilter().filter(this, seqID);
    }
}

