/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;

public class GRegionIDImpl
implements GRegionID {
    private final int regionCode;
    private final int regionID;
    private final int indexID;

    public GRegionIDImpl(int indexID, int regionID) {
        this.indexID = indexID;
        this.regionID = regionID;
        this.regionCode = indexID << 24 | regionID;
        this.check();
    }

    private void check() {
        if (this.indexID > 255 || this.regionID > 0xFFFFFF) {
            throw new GeminiRuntimeException(String.format("error indexID %d or regionID %d, indexID must be less than 255, regionID less than 16777215.", this.indexID, this.regionID));
        }
    }

    public GRegionIDImpl(int regionCode) {
        this.regionCode = regionCode;
        this.regionID = regionCode & 0xFFFFFF;
        this.indexID = regionCode >>> 24;
    }

    @Override
    public int getRegionCode() {
        return this.regionCode;
    }

    @Override
    public int getId() {
        return this.regionID;
    }

    @Override
    public int getIndexID() {
        return this.indexID;
    }

    public String toString() {
        return "_" + this.indexID + "_" + this.regionID;
    }
}

