/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GRegionIDImpl;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContextImpl;
import org.apache.flink.runtime.state.gemini.engine.dbms.Supervisor;
import org.apache.flink.runtime.state.gemini.engine.dbms.SupervisorImpl;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filter.CompositeStateFilter;
import org.apache.flink.runtime.state.gemini.engine.filter.RemoveAllStateFilter;
import org.apache.flink.runtime.state.gemini.engine.filter.TtlStateFilter;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.fs.FileMeta;
import org.apache.flink.runtime.state.gemini.engine.metrics.CacheMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.ExceptionMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileCacheMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileCleanerMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.GeminiMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.HandlerMetrics;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexHashImpl;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotResult;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompletableFuture;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.runtime.state.gemini.time.ProcessingTimeProvider;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiDB {
    private static final Logger LOG = LoggerFactory.getLogger(GeminiDB.class);
    private String dbName;
    private Supervisor geminiSupervisor;
    private final Object lock = new Object();
    private volatile Status geminiDBStatus = Status.INITIALIZE;
    private volatile Throwable internalError;
    private final Map<String, GTable> geminiTableMap = new ConcurrentHashMap<String, GTable>();
    private GContext gContext;
    private MetricGroup dbMetricGroup;
    private GConfiguration configuration;

    @VisibleForTesting
    public GeminiDB() {
        this.geminiDBStatus = Status.OPENED;
    }

    public GeminiDB(String dbName, GConfiguration conf, int sRegionId, int eRegionId, MetricGroup metricGroup) {
        this.dbName = (String)Preconditions.checkNotNull((Object)dbName);
        this.configuration = (GConfiguration)Preconditions.checkNotNull((Object)conf);
        this.gContext = new GContextImpl(this, sRegionId, eRegionId, conf);
        ProcessingTimeProvider timeProvider = new ProcessingTimeProvider();
        this.gContext.setTimeProvider(timeProvider);
        int sampleCount = conf.getMetricSampleCount();
        int histogramWindowSize = conf.getMetricHistogramWindowSize();
        this.dbMetricGroup = metricGroup;
        this.gContext.setDBMetricGroup(this.dbMetricGroup);
        MetricGroup fileManagerMetricGroup = this.dbMetricGroup.addGroup("fileManager");
        this.gContext.setFileManagerMetricGroup(fileManagerMetricGroup);
        GeminiMetrics geminiMetric = new GeminiMetrics(this.dbMetricGroup.addGroup("state"), sampleCount, histogramWindowSize);
        this.gContext.setGeminiMetric(geminiMetric);
        CacheMetrics cacheMetric = new CacheMetrics(this.dbMetricGroup.addGroup("cache"), sampleCount, histogramWindowSize);
        this.gContext.setCacheMetric(cacheMetric);
        HandlerMetrics handlerMetric = new HandlerMetrics(this.dbMetricGroup.addGroup("handler"), sampleCount, histogramWindowSize);
        this.gContext.setHandlerMetric(handlerMetric);
        FileCacheMetrics fileCacheMetrics = new FileCacheMetrics(this.dbMetricGroup.addGroup("fileCache"), sampleCount, histogramWindowSize);
        this.gContext.setFileCacheMetrics(fileCacheMetrics);
        FileCleanerMetrics fileCleanerMetrics = new FileCleanerMetrics(this.dbMetricGroup.addGroup("fileCleaner"), sampleCount, histogramWindowSize);
        this.gContext.setFileCleanerMetrics(fileCleanerMetrics);
        ExceptionMetrics exceptionMetrics = new ExceptionMetrics(this.dbMetricGroup.addGroup("exception"), sampleCount, histogramWindowSize);
        this.gContext.setExceptionMetrics(exceptionMetrics);
        CompositeStateFilter stateFilter = new CompositeStateFilter();
        if (this.gContext.hasTtl()) {
            stateFilter.addStateFilter(new TtlStateFilter());
        }
        stateFilter.addStateFilter(new RemoveAllStateFilter());
        this.gContext.setStateFilter(stateFilter);
        this.geminiSupervisor = new SupervisorImpl(this.gContext);
        this.gContext.setSupervisor(this.geminiSupervisor);
        handlerMetric.registerMetricsCacheStat(this.geminiSupervisor.getWriteBufferManager());
        LOG.info("GeminiDB is created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStatus(Status expected, Status target) {
        Object object = this.lock;
        synchronized (object) {
            if (expected != null && this.geminiDBStatus != expected) {
                return false;
            }
            this.geminiDBStatus = target;
            return true;
        }
    }

    public Status getStatus() {
        return this.geminiDBStatus;
    }

    public Throwable getInternalError() {
        return this.internalError;
    }

    public void setInternalError(Throwable throwable) {
        if (this.setStatus(Status.OPENED, Status.INTERNAL_ERROR)) {
            this.internalError = throwable;
        }
    }

    public synchronized void open() {
        if (!this.setStatus(Status.INITIALIZE, Status.OPENED)) {
            throw new GeminiRuntimeException("open db failed, current status is " + this.geminiDBStatus.toString());
        }
        this.geminiSupervisor.start();
        LOG.info("GeminiDB is opened");
    }

    public void startSnapshot(BackendSnapshotMeta backendSnapshotMeta) throws Exception {
        this.geminiSupervisor.startSnapshot(backendSnapshotMeta);
    }

    public Future<DBSnapshotResult> getSnapshotResult(long checkpointId) {
        CompletableFuture<DBSnapshotResult> result = new CompletableFuture<DBSnapshotResult>();
        SnapshotManager.PendingSnapshot pendingSnapshot = this.geminiSupervisor.getPendingSnapshot(checkpointId);
        SnapshotCompletableFuture snapshotCompletableFuture = pendingSnapshot.getResultFuture();
        snapshotCompletableFuture.whenCompleteAsync((sResult, throwable) -> {
            if (!this.gContext.isDBNormal()) {
                GeminiRuntimeException dbThrowable = new GeminiRuntimeException("DB is in abnormal status: " + this.geminiDBStatus.name());
                result.completeExceptionally(dbThrowable);
                this.gContext.getSupervisor().getSnapshotManager().endSnapshot(checkpointId, dbThrowable);
                return;
            }
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
                this.gContext.getSupervisor().getSnapshotManager().endSnapshot(checkpointId, (Throwable)throwable);
                return;
            }
            Throwable snapshotThrowable = null;
            DBSnapshotResult snapshotResult = null;
            try {
                snapshotResult = pendingSnapshot.getSnapshotOperation().getSnapshotResult();
            }
            catch (Exception e) {
                snapshotThrowable = e;
            }
            finally {
                try {
                    this.gContext.getSupervisor().getSnapshotManager().endSnapshot(checkpointId, snapshotThrowable);
                }
                catch (Exception e) {
                    snapshotThrowable = ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)snapshotThrowable);
                }
                if (snapshotThrowable == null) {
                    result.complete(snapshotResult);
                } else {
                    result.completeExceptionally(snapshotThrowable);
                }
            }
        });
        return result;
    }

    public void restoreFromSnapshot(List<DBSnapshotMeta> metas, Map<String, GTable> restoredTables, int startRegionId, int endRegionId) throws Exception {
        Preconditions.checkNotNull((Object)(metas.size() == 1 ? 1 : 0), (String)"not consider rescale currently");
        MapSerializer<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMappingSerializer = this.getFileMappingSerializer();
        long restoredCheckpointID = 0L;
        int dfsFileMappingSize = 0;
        String restoredDfsBasePath = null;
        HashMap<Integer, String> dfsFileIdToPath = new HashMap<Integer, String>();
        Map<Integer, Map<Integer, Object>> dfsFileMapping = new HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>>();
        boolean hasLocalMeta = false;
        int localFileMappingSize = 0;
        String restoredLocalBasePath = null;
        HashMap<Integer, String> localFileIdToPath = null;
        Map localFileMapping = null;
        LOG.info("Start to restore from snapshot for GeminiDB, metas {}, tables {}, region from {} to {}.", new Object[]{metas, restoredTables, startRegionId, endRegionId});
        for (DBSnapshotMeta meta : metas) {
            restoredCheckpointID = meta.getCheckPointId();
            SnapshotMetaFile.Reader reader = SnapshotMetaFile.getReader(new Path(meta.getSnapshotMetaPath()));
            Throwable throwable = null;
            try {
                String filePath;
                int i;
                int copiedPageIndexSize = reader.readInt();
                for (i = 0; i < copiedPageIndexSize; ++i) {
                    String tableName = reader.readUTF();
                    int regionPageIndexesSize = reader.readInt();
                    for (int j = 0; j < regionPageIndexesSize; ++j) {
                        int regionCode = reader.readInt();
                        GRegionIDImpl regionID = new GRegionIDImpl(regionCode);
                        long lastSeqID = reader.readLong();
                        long removeAllSeqID = reader.readLong();
                        GTable table = restoredTables.get(tableName);
                        GRegionContext regionContext = new GRegionContext(this.gContext, tableName, regionID, table.getTableDescription().getPageSerde(), lastSeqID, removeAllSeqID);
                        PageIndex pageIndex = new PageIndexHashImpl.Builder(reader, regionContext).build();
                        if (pageIndex == null) continue;
                        if (regionID.getIndexID() == 0) {
                            table.setRegion(regionID.getId(), table.getTableDescription().createRegion(this.gContext, table, regionID, pageIndex));
                            continue;
                        }
                        table.setIndexRegion(regionID.getId(), table.getIndexDescription().createRegion(this.gContext, table, regionID, pageIndex));
                    }
                }
                Preconditions.checkState((boolean)reader.readBoolean(), (Object)"dfs meta should always has file mapping");
                dfsFileMappingSize = reader.readInt();
                restoredDfsBasePath = reader.readUTF();
                if (dfsFileMappingSize > 0) {
                    for (i = 0; i < dfsFileMappingSize; ++i) {
                        filePath = reader.readUTF();
                        Integer id = reader.readInt();
                        dfsFileIdToPath.put(id, filePath);
                    }
                    DataInputViewStreamWrapper dataInputView = new DataInputViewStreamWrapper((InputStream)((Object)reader));
                    dfsFileMapping = fileMappingSerializer.deserialize((DataInputView)dataInputView);
                }
                if (!(hasLocalMeta = reader.readBoolean())) continue;
                localFileMappingSize = reader.readInt();
                restoredLocalBasePath = reader.readUTF();
                if (localFileMappingSize <= 0) continue;
                localFileIdToPath = new HashMap<Integer, String>();
                for (i = 0; i < localFileMappingSize; ++i) {
                    filePath = reader.readUTF();
                    Integer id = reader.readInt();
                    localFileIdToPath.put(id, filePath);
                }
                DataInputViewStreamWrapper dataInputView = new DataInputViewStreamWrapper((InputStream)((Object)reader));
                localFileMapping = fileMappingSerializer.deserialize((DataInputView)dataInputView);
            }
            catch (Throwable copiedPageIndexSize) {
                throwable = copiedPageIndexSize;
                throw copiedPageIndexSize;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable copiedPageIndexSize) {
                        throwable.addSuppressed(copiedPageIndexSize);
                    }
                    continue;
                }
                reader.close();
            }
        }
        Preconditions.checkNotNull(restoredDfsBasePath);
        boolean needToBreakLineage = false;
        SnapshotManager snapshotManager = this.geminiSupervisor.getSnapshotManager();
        snapshotManager.setNeedToBreakLineage(needToBreakLineage);
        Map<Long, SnapshotManager.RestoredSnapshot> restoredSnapshots = snapshotManager.restore(restoredCheckpointID, dfsFileIdToPath, restoredDfsBasePath);
        FileManager dfsFileManager = this.gContext.getSupervisor().getDfsFileManager();
        HashMap<Integer, FileMeta.RestoredFileMeta> dbUsedFileMeta = dfsFileMappingSize == 0 ? new HashMap<Integer, FileMeta.RestoredFileMeta>() : this.getRestoredFileMetaUsedByDB(dfsFileIdToPath, dfsFileMapping, !needToBreakLineage);
        dfsFileManager.restore(this.mergeDbAndSnapshotFileMeta(dbUsedFileMeta, restoredSnapshots, !needToBreakLineage));
        if (hasLocalMeta && localFileMappingSize > 0) {
            FileManager localFileManager = this.gContext.getSupervisor().getLocalFileManager();
            Map<Integer, String> newLocalFileIdToPath = this.restoreLocalFile(restoredLocalBasePath, localFileIdToPath, localFileManager.getBasePath());
            localFileManager.restore(this.getRestoredFileMetaUsedByDB(newLocalFileIdToPath, localFileMapping, true));
        }
        LOG.info("Restored successfully from {} for {}, region {} to {}.", new Object[]{metas, restoredTables, startRegionId, endRegionId});
    }

    public GTable getTableOrCreate(GTableDescription tableDescription) throws GeminiRuntimeException {
        return this.geminiTableMap.computeIfAbsent(tableDescription.getTableName(), nothing -> {
            GTable gTable = tableDescription.createTable(this.gContext);
            this.geminiSupervisor.getCacheManager().addTable(gTable);
            this.geminiSupervisor.getWriteBufferManager().addTableNum(tableDescription.getTableName());
            return gTable;
        });
    }

    public void close() {
        this.setStatus(null, Status.CLOSED);
        this.geminiSupervisor.close();
        LOG.info("GeminiDB is closed");
    }

    public GContext getGContext() {
        return this.gContext;
    }

    public GConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, GTable> getGeminiTableMap() {
        return this.geminiTableMap;
    }

    private MapSerializer<Integer, Map<Integer, Tuple2<Integer, Long>>> getFileMappingSerializer() {
        TupleSerializer tuple2Serializer = new TupleSerializer(Tuple2.class, new TypeSerializer[]{IntSerializer.INSTANCE, LongSerializer.INSTANCE});
        MapSerializer groupMapSerializer = new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)tuple2Serializer);
        return new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)groupMapSerializer);
    }

    private Map<Integer, FileMeta.RestoredFileMeta> getRestoredFileMetaUsedByDB(Map<Integer, String> fileIDToPath, Map<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMapping, boolean canDeleteFile) {
        HashMap<Integer, FileMeta.RestoredFileMeta> restoredFileMetas = new HashMap<Integer, FileMeta.RestoredFileMeta>(fileIDToPath.size());
        for (Map.Entry<Integer, Map<Integer, Tuple2<Integer, Long>>> entry : fileMapping.entrySet()) {
            int id = entry.getKey();
            String filePath = fileIDToPath.get(id);
            long dataSize = 0L;
            int dbReference = 0;
            Map<Integer, Tuple2<Integer, Long>> groupInfo = entry.getValue();
            for (Map.Entry<Integer, Tuple2<Integer, Long>> e : groupInfo.entrySet()) {
                dbReference += ((Integer)e.getValue().f0).intValue();
                dataSize += ((Long)e.getValue().f1).longValue();
            }
            long fileSize = 0L;
            FileMeta.RestoredFileMeta meta = FileMeta.RestoredFileMeta.of(id, filePath, fileSize, dataSize, dbReference, 0, canDeleteFile);
            restoredFileMetas.put(id, meta);
        }
        return restoredFileMetas;
    }

    private Map<Integer, FileMeta.RestoredFileMeta> mergeDbAndSnapshotFileMeta(Map<Integer, FileMeta.RestoredFileMeta> dbUsedFileMeta, Map<Long, SnapshotManager.RestoredSnapshot> restoredSnapshots, boolean canDeleteFile) {
        HashMap<Integer, FileMeta.RestoredFileMeta> mergedFileMetas = new HashMap<Integer, FileMeta.RestoredFileMeta>(dbUsedFileMeta);
        for (SnapshotManager.RestoredSnapshot restoredSnapshot : restoredSnapshots.values()) {
            Map<Integer, String> fileMapping = restoredSnapshot.getFileMapping();
            for (Map.Entry<Integer, String> entry : fileMapping.entrySet()) {
                int fileId = entry.getKey();
                String path = entry.getValue();
                FileMeta.RestoredFileMeta fileMeta = (FileMeta.RestoredFileMeta)mergedFileMetas.get(fileId);
                if (fileMeta != null) {
                    ++fileMeta.snapshotReference;
                    continue;
                }
                fileMeta = FileMeta.RestoredFileMeta.of(fileId, path, 0L, 0L, 0, 1, canDeleteFile);
                mergedFileMetas.put(fileId, fileMeta);
            }
        }
        return mergedFileMetas;
    }

    private Map<Integer, String> restoreLocalFile(String restoredLocalBasePath, Map<Integer, String> localFileIdToPath, Path workingBasePath) throws Exception {
        HashMap<Integer, String> newLocalFileIdToPath = new HashMap<Integer, String>();
        File restoredLocalBaseDir = new File(new Path(restoredLocalBasePath).toUri().getPath());
        File workingBaseDir = new File(workingBasePath.toUri().getPath());
        if (workingBaseDir.exists()) {
            FileUtils.deleteDirectory((File)workingBaseDir);
        }
        if (!workingBaseDir.mkdirs()) {
            throw new IOException("Local working directory for  already exists: " + workingBaseDir);
        }
        for (Map.Entry<Integer, String> entry : localFileIdToPath.entrySet()) {
            int fileId = entry.getKey();
            String fileName = entry.getValue();
            File src = new File(restoredLocalBaseDir, fileName);
            File target = new File(workingBaseDir, fileName);
            try {
                Files.createLink(target.toPath(), src.toPath());
            }
            catch (Exception e) {
                LOG.error("Fail to create hard link from {} to {}, {}", new Object[]{src.getAbsolutePath(), target.getAbsolutePath(), e});
                throw e;
            }
            newLocalFileIdToPath.put(fileId, target.getAbsolutePath());
        }
        return newLocalFileIdToPath;
    }

    public static enum Status {
        INITIALIZE,
        OPENED,
        CLOSING,
        CLOSED,
        INTERNAL_ERROR;

    }
}

