/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.dbms;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;

public class DiscardOrEvictPageReleaseManager {
    private final Map<GByteBuffer, Object> discardedPageHaveReferenceMonitor = new ConcurrentHashMap<GByteBuffer, Object>();
    private final Map<GByteBuffer, Object> evictedPageHaveReferenceMonitor = new ConcurrentHashMap<GByteBuffer, Object>();
    private final ConcurrentLinkedQueue<GByteBuffer> waitSafeSeqQueue = new ConcurrentLinkedQueue();
    private final AtomicLong totalWaitQueueSize = new AtomicLong(0L);
    private final GContext gContext;

    public DiscardOrEvictPageReleaseManager(GContext gContext) {
        this.gContext = gContext;
    }

    public void addMonitorPageStillHaveReference(GByteBuffer gByteBuffer, ReferenceCount.ReleaseType releaseType, Object detail) {
        if (releaseType == ReferenceCount.ReleaseType.Discard) {
            this.discardedPageHaveReferenceMonitor.put(gByteBuffer, detail);
        } else {
            this.evictedPageHaveReferenceMonitor.put(gByteBuffer, detail);
        }
    }

    public void addWaitSafeQueue(ReferenceCount.ReleaseType releaseType, GByteBuffer gByteBuffer) {
        if (gByteBuffer.getCnt() != 0) {
            this.addMonitorPageStillHaveReference(gByteBuffer, releaseType, "safeQueue");
            return;
        }
        gByteBuffer.setSeqID(this.gContext.getAccessNumber());
        this.totalWaitQueueSize.incrementAndGet();
        this.waitSafeSeqQueue.add(gByteBuffer);
    }

    public GByteBuffer getGByteBufferFromWaitQueue() {
        GByteBuffer gByteBuffer = this.waitSafeSeqQueue.poll();
        if (gByteBuffer != null) {
            this.totalWaitQueueSize.decrementAndGet();
        }
        return gByteBuffer;
    }

    public Map<GByteBuffer, Object> getDiscardedPageHaveReferenceMonitor() {
        return this.discardedPageHaveReferenceMonitor;
    }

    public Map<GByteBuffer, Object> getEvictedPageHaveReferenceMonitor() {
        return this.evictedPageHaveReferenceMonitor;
    }

    public AtomicLong getTotalWaitQueueSize() {
        return this.totalWaitQueueSize;
    }
}

