/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.dbms;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.GeminiDB;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.dbms.Supervisor;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.metrics.CacheMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.ExceptionMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileCacheMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileCleanerMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.GeminiMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.HandlerMetrics;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.time.TimeProvider;
import org.apache.flink.util.Preconditions;

public class GContextImpl
implements GContext {
    private final GeminiDB geminiDB;
    private final GConfiguration gConfiguration;
    private final int startRegionId;
    private final int endRegionId;
    private volatile long curVersion;
    private Supervisor supervisor;
    private GeminiMetrics geminiMetrics;
    private CacheMetrics cacheMetrics;
    private HandlerMetrics handlerMetrics;
    private FileCacheMetrics fileCacheMetrics;
    private FileCleanerMetrics fileCleanerMetrics;
    private ExceptionMetrics exceptionMetrics;
    private TimeProvider timeProvider;
    private final long ttl;
    private StateFilter stateFilter;
    private MetricGroup dbMetricGroup;
    private MetricGroup fileManagerMetricGroup;
    private volatile long restoredVersion;
    private AtomicLong accessNumber;
    private final GCompressAlgorithm inPageCompressAlgorithm;
    private final GCompressAlgorithm flushWholePageCompressAlgorithm;

    public GContextImpl(GeminiDB geminiDB, int sRegionId, int eRegionID, GConfiguration gConfiguration) {
        this.geminiDB = (GeminiDB)Preconditions.checkNotNull((Object)geminiDB);
        this.startRegionId = sRegionId;
        this.endRegionId = eRegionID;
        this.gConfiguration = gConfiguration;
        this.restoredVersion = -1L;
        this.curVersion = -1L;
        this.ttl = gConfiguration.getTtl();
        this.accessNumber = new AtomicLong(0L);
        this.inPageCompressAlgorithm = gConfiguration.getInPageGCompressAlgorithm();
        this.flushWholePageCompressAlgorithm = gConfiguration.getFlushWholePageGCompressAlgorithm();
    }

    @Override
    public GeminiDB getGeminiDB() {
        return this.geminiDB;
    }

    @Override
    public long getCurVersion() {
        return this.curVersion;
    }

    @Override
    public void increaseCurVersion() {
        ++this.curVersion;
    }

    @Override
    public void setRestoredVersion(long version) {
        this.restoredVersion = version;
    }

    @Override
    public long getRestoredVersion() {
        return this.restoredVersion;
    }

    @Override
    public int getStartRegionId() {
        return this.startRegionId;
    }

    @Override
    public int getEndRegionId() {
        return this.endRegionId;
    }

    @Override
    public Supervisor getSupervisor() {
        return this.supervisor;
    }

    @Override
    public void setSupervisor(Supervisor supervisor) {
        this.supervisor = supervisor;
    }

    @Override
    public GConfiguration getGConfiguration() {
        return this.gConfiguration;
    }

    @Override
    public void setDBMetricGroup(MetricGroup metricGroup) {
        this.dbMetricGroup = metricGroup;
    }

    @Override
    public MetricGroup getDBMetricGroup() {
        return this.dbMetricGroup;
    }

    @Override
    public void setFileManagerMetricGroup(MetricGroup metricGroup) {
        this.fileManagerMetricGroup = metricGroup;
    }

    @Override
    public MetricGroup getFileManagerMetricGroup() {
        return this.fileManagerMetricGroup;
    }

    @Override
    public void setGeminiMetric(GeminiMetrics geminiMetric) {
        this.geminiMetrics = geminiMetric;
    }

    @Override
    public GeminiMetrics getGeminiMetric() {
        return this.geminiMetrics;
    }

    @Override
    public void setCacheMetric(CacheMetrics cacheMetrics) {
        this.cacheMetrics = cacheMetrics;
    }

    @Override
    public CacheMetrics getCacheMetric() {
        return this.cacheMetrics;
    }

    @Override
    public void setHandlerMetric(HandlerMetrics handlerMetric) {
        this.handlerMetrics = handlerMetric;
    }

    @Override
    public HandlerMetrics getHandlerMetric() {
        return this.handlerMetrics;
    }

    @Override
    public void setFileCacheMetrics(FileCacheMetrics fileCacheMetrics) {
        this.fileCacheMetrics = fileCacheMetrics;
    }

    @Override
    public FileCacheMetrics getFileCacheMetrics() {
        return this.fileCacheMetrics;
    }

    @Override
    public void setFileCleanerMetrics(FileCleanerMetrics fileCleanerMetrics) {
        this.fileCleanerMetrics = fileCleanerMetrics;
    }

    @Override
    public FileCleanerMetrics getFileCleanerMetrics() {
        return this.fileCleanerMetrics;
    }

    @Override
    public void setExceptionMetrics(ExceptionMetrics exceptionMetrics) {
        this.exceptionMetrics = exceptionMetrics;
    }

    @Override
    public ExceptionMetrics getExceptionMetrics() {
        return this.exceptionMetrics;
    }

    @Override
    public void setTimeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @Override
    public boolean hasTtl() {
        return this.ttl > 0L;
    }

    @Override
    public boolean isExpired(long ts, long currentTime) {
        return this.hasTtl() && ts + Math.min(Long.MAX_VALUE - ts, this.ttl) <= currentTime;
    }

    @Override
    public void setStateFilter(StateFilter stateFilter) {
        this.stateFilter = stateFilter;
    }

    @Override
    public StateFilter getStateFilter() {
        return this.stateFilter;
    }

    @Override
    public void incAccessNumber() {
        this.accessNumber.incrementAndGet();
    }

    @Override
    public long getAccessNumber() {
        return this.accessNumber.get();
    }

    @Override
    public long incrementAndGetAccessNumber() {
        return this.accessNumber.incrementAndGet();
    }

    @Override
    public long getMinSnapshotAccessNumber() {
        return this.supervisor.getSnapshotManager().getMinRunningSnapshotAccessNumber();
    }

    @Override
    public GCompressAlgorithm getInPageGCompressAlgorithm() {
        return this.inPageCompressAlgorithm;
    }

    @Override
    public GCompressAlgorithm getFlushWholePageGCompressAlgorithm() {
        return this.flushWholePageCompressAlgorithm;
    }

    @Override
    public void setDBInternalError(Throwable throwable) {
        this.geminiDB.setInternalError(throwable);
    }

    @Override
    public void checkDBStatus() {
        GeminiDB.Status status = this.geminiDB.getStatus();
        if (status != GeminiDB.Status.OPENED) {
            switch (status) {
                case CLOSING: {
                    throw new GeminiRuntimeException("Gemini is being closed");
                }
                case CLOSED: {
                    throw new GeminiRuntimeException("Gemini has been closed");
                }
                case INITIALIZE: {
                    throw new GeminiRuntimeException("Gemini has not been opened");
                }
                case INTERNAL_ERROR: {
                    throw new GeminiRuntimeException("Internal error occurred, " + this.geminiDB.getInternalError());
                }
            }
        }
    }

    @Override
    public GeminiDB.Status getDBStatus() {
        return this.geminiDB.getStatus();
    }

    @Override
    public boolean isDBNormal() {
        return this.geminiDB.getStatus() == GeminiDB.Status.OPENED;
    }
}

