/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.filecache;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCacheStat;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;

public abstract class FileCache
implements Closeable {
    public static final Long INFINITE_CAPACITY = Long.MAX_VALUE;
    protected final long capacity;
    protected final FileCacheStat fileCacheStat;

    public FileCache(long capacity, FileCacheStat fileCacheStat) {
        this.capacity = capacity;
        this.fileCacheStat = (FileCacheStat)Preconditions.checkNotNull((Object)fileCacheStat);
    }

    public long capacity() {
        return this.capacity;
    }

    public abstract boolean isCached(PageAddress var1);

    public abstract void addPage(PageAddress var1, GRegionContext var2, EventExecutor var3, @Nullable BiConsumer<Boolean, Throwable> var4);

    public abstract DataPage getPage(PageAddress var1, GRegionContext var2, EventExecutor var3);

    public abstract void discardPage(PageAddress var1, GRegionContext var2, EventExecutor var3);

    public abstract void flushPage(PageAddress var1, GRegionContext var2, EventExecutor var3, boolean var4, @Nullable BiConsumer<Boolean, Throwable> var5);

    public abstract void sync(EventExecutor var1) throws IOException;

    public FileCacheStat getFileCacheStat() {
        return this.fileCacheStat;
    }
}

