/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.filecache;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

public class FileCacheStat {
    public AtomicLong hitCount = new AtomicLong(0L);
    public AtomicLong hitSize = new AtomicLong(0L);
    public AtomicLong missCount = new AtomicLong(0L);
    public AtomicLong missSize = new AtomicLong(0L);
    public AtomicLong totalLocalWriteCount = new AtomicLong(0L);
    public AtomicLong totalLocalWriteTime = new AtomicLong(0L);
    public AtomicLong totalLocalWriteSize = new AtomicLong(0L);
    public AtomicLong totalLocalOriDataSize = new AtomicLong(0L);
    public AtomicLong totalLocalReadCount = new AtomicLong(0L);
    public AtomicLong totalLocalReadTime = new AtomicLong(0L);
    public AtomicLong totalLocalReadSize = new AtomicLong(0L);
    public AtomicLong totalDFSWriteCount = new AtomicLong(0L);
    public AtomicLong totalDFSWriteTime = new AtomicLong(0L);
    public AtomicLong totalDFSWriteSize = new AtomicLong(0L);
    public AtomicLong totalDFSReadCount = new AtomicLong(0L);
    public AtomicLong totalDFSReadTime = new AtomicLong(0L);
    public AtomicLong totalDFSReadSize = new AtomicLong(0L);

    public void addHitSize(long size) {
        this.hitCount.addAndGet(1L);
        this.hitSize.addAndGet(size);
    }

    public void addMissSize(long size) {
        this.missCount.addAndGet(1L);
        this.missSize.addAndGet(size);
    }

    public void addLocalWrite(long writeSize, long oriDataSize, long writeTime) {
        this.totalLocalWriteCount.addAndGet(1L);
        this.totalLocalWriteSize.addAndGet(writeSize);
        this.totalLocalOriDataSize.addAndGet(oriDataSize);
        this.totalLocalWriteTime.addAndGet(writeTime);
    }

    public void addLocalRead(long readSize, long readTime) {
        this.totalLocalReadCount.addAndGet(1L);
        this.totalLocalReadSize.addAndGet(readSize);
        this.totalLocalReadTime.addAndGet(readTime);
    }

    public void addDFSWrite(long writeSize, long writeTime) {
        this.totalDFSWriteCount.addAndGet(1L);
        this.totalDFSWriteSize.addAndGet(writeSize);
        this.totalDFSWriteTime.addAndGet(writeTime);
    }

    public void addDFSRead(long readSize, long readTime) {
        this.totalDFSReadCount.addAndGet(1L);
        this.totalDFSReadSize.addAndGet(readSize);
        this.totalDFSReadTime.addAndGet(readTime);
    }

    private long getAverage(AtomicLong a, AtomicLong b) {
        if (b.get() == 0L) {
            return 0L;
        }
        return a.get() / b.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hitCount", this.hitCount.get()).add("hitSize", this.hitSize.get()).add("missCount", this.missCount.get()).add("missSize", this.missSize.get()).add("averageLocalWriteSize", this.getAverage(this.totalLocalWriteSize, this.totalLocalWriteCount)).add("averageLocalWriteTime(ns)", this.getAverage(this.totalLocalWriteTime, this.totalLocalWriteCount)).add("averageLocalReadSize", this.getAverage(this.totalLocalReadSize, this.totalLocalReadCount)).add("averageLocalReadTime(ns)", this.getAverage(this.totalLocalReadTime, this.totalLocalReadCount)).add("averageDFSWriteSize", this.getAverage(this.totalDFSWriteSize, this.totalDFSWriteCount)).add("averageDFSWriteTime(ns)", this.getAverage(this.totalDFSWriteTime, this.totalDFSWriteCount)).add("averageDFSReadSize", this.getAverage(this.totalDFSReadSize, this.totalDFSReadCount)).add("averageDFSReadTime(ns)", this.getAverage(this.totalDFSReadTime, this.totalDFSReadCount)).toString();
    }
}

