/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.IOException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileID;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiOutputStream;
import org.apache.flink.util.Preconditions;

public class FileWriterImpl
extends FileWriter {
    private final FileManager fileManager;
    private final FileID fileID;
    private final String filePath;
    private final Object lock = new Object();
    private volatile boolean closed;

    public FileWriterImpl(GeminiOutputStream geminiOutputStream, FileManager fileManager, FileID fileID, String filePath) {
        super(geminiOutputStream);
        this.fileManager = (FileManager)Preconditions.checkNotNull((Object)fileManager);
        this.fileID = (FileID)Preconditions.checkNotNull((Object)fileID);
        this.filePath = filePath;
        this.closed = false;
    }

    @Override
    public FileID getFileID() {
        return this.fileID;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public long getAddress() throws IOException {
        return this.fileManager.getAddress(this.fileID, this.getPos());
    }

    @Override
    public long getSize() throws IOException {
        return this.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                super.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        if (!this.closed) {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                super.sync();
            }
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void increasFailCount() {
    }

    @Override
    public void resetFailCount() {
    }

    public String toString() {
        return "FileWriterImpl: {fileID=" + this.fileID + ", filePath=" + this.filePath + "}";
    }
}

