/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;

public class GeminiLocalByteBufferableInputStream
extends FSDataInputStream {
    private final FileInputStream fis;
    private final FileChannel fileChannel;

    public GeminiLocalByteBufferableInputStream(Path workDir, Path localFile) throws FileNotFoundException {
        File file = this.pathToFile(workDir, localFile);
        this.fis = new FileInputStream(file);
        this.fileChannel = this.fis.getChannel();
    }

    private File pathToFile(Path workDir, Path path) {
        if (!path.isAbsolute()) {
            path = new Path(workDir, path);
        }
        return new File(path.toUri().getPath());
    }

    public void seek(long desired) throws IOException {
        if (desired != this.getPos()) {
            this.fileChannel.position(desired);
        }
    }

    public long getPos() throws IOException {
        return this.fileChannel.position();
    }

    public int read() throws IOException {
        return this.fis.read();
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public int available() throws IOException {
        return this.fis.available();
    }

    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }

    public int read(int position, @Nonnull ByteBuffer buffer) throws IOException {
        return this.fileChannel.read(buffer, position);
    }
}

