/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.handler;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.LockSupport;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.handler.GeminiEventExecutorGroup;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutorGroup;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.SingleThreadEventExecutor;

public final class GeminiEventExecutor
extends SingleThreadEventExecutor {
    private ConcurrentLinkedQueue<Runnable> queue;
    private final long sleepTimeNs;
    private final GContext gContext;

    public GeminiEventExecutor(GeminiEventExecutorGroup parent, ThreadFactory threadFactory, long sleepTimeNs, GContext gContext) {
        super((EventExecutorGroup)parent, threadFactory, true);
        this.sleepTimeNs = sleepTimeNs;
        this.gContext = gContext;
    }

    protected void run() {
        do {
            Runnable task;
            if ((task = this.queue.poll()) != null && this.gContext.isDBNormal()) {
                task.run();
                this.updateLastExecutionTime();
                continue;
            }
            LockSupport.parkNanos(this.sleepTimeNs);
        } while (!this.confirmShutdown());
    }

    public void execute(Runnable task) {
        super.execute(task);
    }

    protected Queue<Runnable> newTaskQueue() {
        this.queue = new ConcurrentLinkedQueue();
        return this.queue;
    }
}

