/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.handler;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.handler.AbstractRegionHandler;
import org.apache.flink.runtime.state.gemini.engine.handler.PageHandler;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValueMap;
import org.apache.flink.runtime.state.gemini.engine.memstore.SegmentKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2KeyImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreKMap;

public class PageKMapHandlerImpl<K, MK, MV>
extends AbstractRegionHandler
implements PageHandler {
    private final SegmentKMapImpl<K, MK, MV> segment;
    private final PageStoreKMap<K, MK, MV> pageStore;
    private final boolean onlyEstimatedSize;

    public PageKMapHandlerImpl(GRegionContext gRegionContext, PageStoreKMap<K, MK, MV> pageStore, SegmentKMapImpl<K, MK, MV> segment, boolean onlyEstimatedSize) {
        super(gRegionContext);
        this.segment = segment;
        this.pageStore = pageStore;
        this.onlyEstimatedSize = onlyEstimatedSize;
    }

    @Override
    public void handle() {
        if (this.onlyEstimatedSize) {
            int keySize = this.estimateKeySize(this.segment);
            if (keySize > 0) {
                this.gRegionContext.getWriteBufferStats().setAverageKeyLen(keySize);
                this.gRegionContext.getWriteBufferStats().setAverageValueLen(this.estimateValueSize(this.segment));
            } else {
                this.gRegionContext.getWriteBufferStats().setAverageKeyLen(-2);
            }
            return;
        }
        PageIndex pageIndex = this.pageStore.getPageIndex();
        HashMap organizedData = new HashMap();
        this.segment.getDataMap().forEach((k, v) -> organizedData.computeIfAbsent(pageIndex.getPageIndexContext(k, true), nothing -> new ArrayList()).add(Tuple2.of((Object)k, (Object)v)));
        HashSet needSplitPageList = new HashSet();
        Iterator iterator = organizedData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.pageStore == null) {
                System.out.println("KK,Null PageStore.");
            }
            if (((PageIndexContext)entry.getKey()).isNeedSplit()) {
                needSplitPageList.add(entry.getKey());
            }
            this.pageStore.addPage((PageIndexContext)entry.getKey(), (List)entry.getValue(), this.segment.getVersion());
            iterator.remove();
        }
        if (needSplitPageList.size() > 0) {
            needSplitPageList.stream().forEach(needSplitPage -> this.pageStore.splitPage((PageIndexContext)needSplitPage));
        }
        this.pageStore.checkResource();
    }

    private int estimateKeySize(SegmentKMapImpl<K, MK, MV> segment) {
        if (segment.getDataMap() == null || segment.getDataMap().isEmpty()) {
            return 0;
        }
        try {
            PageSerdeFlink2KeyImpl pageSerdeFlink = (PageSerdeFlink2KeyImpl)this.gRegionContext.getPageSerdeFlink();
            ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
            DataOutputViewStreamWrapper outputView = new DataOutputViewStreamWrapper((OutputStream)outputStream);
            for (K key : segment.getDataMap().keySet()) {
                pageSerdeFlink.getKeySerde().serialize(key, (DataOutputView)outputView);
            }
            return outputStream.getPosition() / segment.getDataMap().size();
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("estimateKeySize has exception=" + e.getMessage(), e);
        }
    }

    private int estimateValueSize(SegmentKMapImpl<K, MK, MV> segment) {
        if (segment.getDataMap() == null || segment.getDataMap().isEmpty()) {
            return 0;
        }
        try {
            PageSerdeFlink2KeyImpl pageSerdeFlink = (PageSerdeFlink2KeyImpl)this.gRegionContext.getPageSerdeFlink();
            ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
            DataOutputViewStreamWrapper outputView = new DataOutputViewStreamWrapper((OutputStream)outputStream);
            int totalCount = 0;
            for (GSValueMap<MK, MV> value : segment.getDataMap().values()) {
                if (value.getValue() == null) continue;
                totalCount += value.getValue().size();
                pageSerdeFlink.getMapValueTypeSerializer().serialize(value.getValue(), (DataOutputView)outputView);
            }
            return totalCount == 0 ? 0 : outputStream.getPosition() / totalCount + 9;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("estimateValueSize has exception=" + e.getMessage(), e);
        }
    }
}

