/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GeminiKSortedMap;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValueMap;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferKSortedMapHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreHashKSortedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;
import org.apache.flink.runtime.util.EmptyIterator;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;
import org.apache.flink.util.Preconditions;

public class GRegionKSortedMapImpl<K, MK, MV>
extends AbstractGRegionKMapImpl<K, MK, MV, SortedMap<MK, MV>>
implements GeminiKSortedMap<K, MK, MV> {
    private GComparator<MK> comparator;

    public GRegionKSortedMapImpl(GRegionContext gRegionContext) {
        super(gRegionContext, null);
    }

    public GRegionKSortedMapImpl(GRegionContext gRegionContext, PageIndex pageIndex) {
        super(gRegionContext, pageIndex);
    }

    @Override
    void init(PageIndex pageIndex) {
        PageSerdeFlink2Key pageSerdeFlink = (PageSerdeFlink2Key)this.gRegionContext.getPageSerdeFlink();
        Preconditions.checkArgument((pageSerdeFlink.getMapComparator() != null ? 1 : 0) != 0, (Object)"no MapComparator,error type");
        this.pageStore = new PageStoreHashKSortedMapImpl(this, pageIndex, this.regionEventExecutor);
        this.comparator = pageSerdeFlink.getMapComparator();
        this.writeBuffer = new WriteBufferKSortedMapHashImpl(this, this.regionEventExecutor, this.pageStore, this.comparator);
    }

    @Override
    public Map.Entry<MK, MV> firstEntry(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        GSValue mapFromWriteBuffer = this.writeBuffer.get((Object)key);
        Map mapFromPageStore = (Map)this.pageStore.get(key);
        TreeMap<MK, MV> map = this.mergeTwoMap((GSValueMap<MK, MV>)mapFromWriteBuffer, mapFromPageStore, false);
        return map == null ? null : this.copyEntry(map.firstEntry());
    }

    @Override
    public Map.Entry<MK, MV> lastEntry(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        GSValue mapFromWriteBuffer = this.writeBuffer.get((Object)key);
        Map mapFromPageStore = (Map)this.pageStore.get(key);
        TreeMap<MK, MV> map = this.mergeTwoMap((GSValueMap<MK, MV>)mapFromWriteBuffer, mapFromPageStore, false);
        return map == null ? null : this.copyEntry(map.lastEntry());
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> headIterator(K key, MK endMapKey) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        GSValue mapFromWriteBuffer = this.writeBuffer.get((Object)key);
        Map mapFromPageStore = (Map)this.pageStore.get(key);
        TreeMap<MK, MV> map = this.mergeTwoMap((GSValueMap<MK, MV>)mapFromWriteBuffer, mapFromPageStore, true);
        return map == null ? EmptyIterator.get() : map.headMap(endMapKey).entrySet().iterator();
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> tailIterator(K key, MK startMapKey) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        GSValue mapFromWriteBuffer = this.writeBuffer.get((Object)key);
        Map mapFromPageStore = (Map)this.pageStore.get(key);
        TreeMap<MK, MV> map = this.mergeTwoMap((GSValueMap<MK, MV>)mapFromWriteBuffer, mapFromPageStore, true);
        return map == null ? EmptyIterator.get() : map.tailMap(startMapKey).entrySet().iterator();
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> subIterator(K key, MK startMapKey, MK endMapKey) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        GSValue mapFromWriteBuffer = this.writeBuffer.get((Object)key);
        Map mapFromPageStore = (Map)this.pageStore.get(key);
        TreeMap<MK, MV> map = this.mergeTwoMap((GSValueMap<MK, MV>)mapFromWriteBuffer, mapFromPageStore, true);
        return map == null ? EmptyIterator.get() : map.subMap(startMapKey, endMapKey).entrySet().iterator();
    }

    @Override
    public void put(K key, SortedMap<MK, MV> value) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        long seqID = this.gRegionContext.getNextSeqID();
        this.writeBuffer.put(key, Maps.transformEntries(value, (k, v) -> GSValue.of(v, GValueType.PutValue, seqID)));
    }

    @Override
    public SortedMap<MK, MV> get(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        return this.internalGet((Object)key, true);
    }

    @Override
    public SortedMap<MK, MV> getOrDefault(K key, SortedMap<MK, MV> defaultValue) {
        this.gContext.checkDBStatus();
        Object ret = this.get((Object)key);
        return ret == null || ret.isEmpty() ? defaultValue : ret;
    }

    @Override
    public Map<K, SortedMap<MK, MV>> getAll() {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        HashMap results = new HashMap();
        this.getAll(results);
        return results;
    }

    private SortedMap<MK, MV> genMapFromGSValueMap(GSValueMap<MK, MV> gsValueMap) {
        return this.genMapFromGSValueMap(gsValueMap, false);
    }

    private SortedMap<MK, MV> genMapFromGSValueMap(GSValueMap<MK, MV> gsValueMap, boolean checkReadCopy) {
        SortedMap valueMap = (SortedMap)gsValueMap.getValue();
        TreeMap ret = new TreeMap(this.comparator.getJDKCompactor());
        if (valueMap != null) {
            for (Map.Entry entry : valueMap.entrySet()) {
                GSValue gsValue = (GSValue)entry.getValue();
                if (GValueType.Delete.equals((Object)gsValue.getValueType()) || this.gRegionContext.filterState(gsValue.getSeqID())) continue;
                Object mk = entry.getKey();
                Object mv = ((GSValue)entry.getValue()).getValue();
                ret.put(checkReadCopy ? this.copyMKIfNeeded(mk) : mk, checkReadCopy ? this.copyMVIfNeeded(mv) : mv);
            }
        }
        return ret.isEmpty() ? null : ret;
    }

    private TreeMap<MK, MV> mergeTwoMap(GSValueMap<MK, MV> mapFromWriteBuffer, Map<MK, GSValue<MV>> mapFromPageStore) {
        return this.mergeTwoMap(mapFromWriteBuffer, mapFromPageStore, false);
    }

    private TreeMap<MK, MV> mergeTwoMap(GSValueMap<MK, MV> mapFromWriteBuffer, Map<MK, GSValue<MV>> mapFromPageStore, boolean checkReadCopy) {
        TreeMap<MK, Object> map = new TreeMap<MK, Object>(this.comparator.getJDKCompactor());
        if (mapFromPageStore != null) {
            for (Map.Entry<Object, GSValue<Object>> entry : mapFromPageStore.entrySet()) {
                if (this.gRegionContext.filterState(entry.getValue().getSeqID())) continue;
                if (entry.getValue().getValueType() == GValueType.PutValue) {
                    map.put(entry.getKey(), entry.getValue().getValue());
                    continue;
                }
                Preconditions.checkState((boolean)entry.getValue().getValueType().equals((Object)GValueType.Delete));
            }
        }
        if (mapFromWriteBuffer != null) {
            for (Map.Entry<Object, GSValue<Object>> entry : mapFromWriteBuffer.getValue().entrySet()) {
                if (this.gRegionContext.filterState(entry.getValue().getSeqID())) continue;
                if (entry.getValue().getValueType().equals((Object)GValueType.PutValue)) {
                    Object mk = entry.getKey();
                    Object mv = entry.getValue().getValue();
                    map.put(checkReadCopy ? this.copyMKIfNeeded(mk) : mk, checkReadCopy ? this.copyMVIfNeeded(mv) : mv);
                    continue;
                }
                Preconditions.checkState((boolean)entry.getValue().getValueType().equals((Object)GValueType.Delete));
                map.remove(entry.getKey());
            }
        }
        return map == null || map.isEmpty() ? null : map;
    }

    @Override
    public void getAll(Map<K, SortedMap<MK, MV>> results) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        HashSet allKeysIncludeDelete = new HashSet();
        this.writeBuffer.allKeysIncludeDeleted(allKeysIncludeDelete);
        this.pageStore.allKeysIncludeDeleted(allKeysIncludeDelete);
        for (Object key : allKeysIncludeDelete) {
            Object mapResult = this.get(key);
            if (mapResult == null) continue;
            results.put(this.copyKeyIfNeeded(key), (SortedMap<MK, MV>)mapResult);
        }
    }

    @Override
    protected SortedMap<MK, MV> internalGet(K key, boolean checkReadCopy) {
        Map mapFromPageStore;
        TreeMap<MK, MV> ret;
        GSValue map = this.writeBuffer.get((Object)key);
        if (map != null) {
            switch (map.getValueType()) {
                case Delete: {
                    return null;
                }
                case PutMap: {
                    return this.genMapFromGSValueMap((GSValueMap<MK, MV>)map, checkReadCopy);
                }
            }
        }
        return (ret = this.mergeTwoMap((GSValueMap<MK, MV>)map, mapFromPageStore = (Map)this.pageStore.get(key), checkReadCopy)) == null || ret.isEmpty() ? null : ret;
    }

    private Map.Entry<MK, MV> copyEntry(final Map.Entry<MK, MV> entry) {
        if (entry == null || !this.readCopy) {
            return entry;
        }
        return new Map.Entry<MK, MV>(){
            private MK mk;
            private MV mv;
            {
                this.mk = GRegionKSortedMapImpl.this.mkSerializer.copy(entry.getKey());
                this.mv = GRegionKSortedMapImpl.this.mvSerializer.copy(entry.getValue());
            }

            @Override
            public MK getKey() {
                return this.mk;
            }

            @Override
            public MV getValue() {
                return this.mv;
            }

            @Override
            public MV setValue(MV value) {
                Object oldValue = this.mv;
                this.mv = value;
                return oldValue;
            }
        };
    }
}

