/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionIDImpl;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKVImpl;
import org.apache.flink.util.Preconditions;

public class GTableOneKeyImpl<K, S>
implements GTable<K> {
    private final int startGroup;
    private final int numberGroups;
    private final int endGroup;
    private final int maxParallelism;
    private final GTableDescription description;
    private final GContext gContext;
    private GRegionKVImpl<K, S>[] regions;

    public GTableOneKeyImpl(GTableDescription description, int startGroup, int numberGroups, int maxParallelism, GContext gContext) {
        this.description = (GTableDescription)Preconditions.checkNotNull((Object)description);
        this.startGroup = startGroup;
        this.numberGroups = numberGroups;
        this.endGroup = startGroup + numberGroups;
        this.maxParallelism = maxParallelism;
        this.regions = new GRegionKVImpl[numberGroups];
        this.gContext = (GContext)Preconditions.checkNotNull((Object)gContext);
    }

    @Override
    public GTableDescription getTableDescription() {
        return this.description;
    }

    @Override
    public GRegionKVImpl<K, S> getRegion(K key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key, this.maxParallelism);
        int offset = group - this.startGroup;
        GRegionKVImpl region = this.regions[offset];
        if (region == null) {
            this.regions[offset] = region = (GRegionKVImpl)this.description.createRegion(this.gContext, this, new GRegionIDImpl(0, group));
        }
        return region;
    }

    @Override
    public Iterator<GRegion> regionIterator() {
        return new Iterator<GRegion>(){
            private int currentIndex = 0;

            private void advance() {
                ++this.currentIndex;
                while (this.currentIndex < GTableOneKeyImpl.this.regions.length && GTableOneKeyImpl.this.regions[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex < GTableOneKeyImpl.this.regions.length && GTableOneKeyImpl.this.regions[this.currentIndex] != null) {
                    return true;
                }
                this.advance();
                return this.currentIndex < GTableOneKeyImpl.this.regions.length;
            }

            @Override
            public GRegion next() {
                return GTableOneKeyImpl.this.regions[this.currentIndex++];
            }
        };
    }

    @Override
    public Iterator<GRegion> indexRegionIterator() {
        return Collections.emptyIterator();
    }

    @Override
    public void setRegion(int idx, GRegion region) {
        Preconditions.checkArgument((idx >= this.startGroup && idx < this.endGroup ? 1 : 0) != 0);
        this.regions[idx - this.startGroup] = (GRegionKVImpl)region;
    }

    @Override
    public void setIndexRegion(int idx, GRegion indexRegion) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public GTableDescription getIndexDescription() {
        throw new UnsupportedOperationException();
    }
}

