/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Map;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionIDImpl;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.GeminiPKey2;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGTableSubKeyedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.util.Preconditions;

public class GTableSubKeyedMapImpl<K, N, MK, MV>
extends AbstractGTableSubKeyedMapImpl<K, N, MK, MV> {
    public GTableSubKeyedMapImpl(GTableDescription description, int startGroup, int numberGroups, int maxParallelism, GContext context) {
        super(description, startGroup, numberGroups, maxParallelism, context);
    }

    public AbstractGRegionKMapImpl<GeminiPKey2<K, N>, MK, MV, ? extends Map<MK, MV>> getRegion(GeminiPKey2<K, N> key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key.getFirstKey(), this.maxParallelism);
        int offset = group - this.startGroup;
        AbstractGRegionKMapImpl region = this.regions[offset];
        if (region == null) {
            this.regions[offset] = region = (GRegionKMapImpl)this.description.createRegion(this.context, this, new GRegionIDImpl(0, group));
        }
        return region;
    }

    @Override
    public void setRegion(int idx, GRegion region) {
        Preconditions.checkArgument((idx >= this.startGroup && idx < this.endGroup ? 1 : 0) != 0);
        this.regions[idx - this.startGroup] = (GRegionKMapImpl)region;
    }

    @Override
    public void setIndexRegion(int idx, GRegion indexRegion) {
        Preconditions.checkArgument((idx >= this.startGroup && idx < this.endGroup ? 1 : 0) != 0);
        this.keyIndexRegions[idx - this.startGroup] = (GRegionKMapImpl)indexRegion;
    }
}

