/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionIDImpl;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.util.Preconditions;

public class GTableSubKeyedValueImpl<K, N, V>
implements GTable<K> {
    private GRegionKMapImpl<K, N, V>[] regions;
    private final int startGroup;
    private final int numberGroups;
    private final int endGroup;
    private final int maxParallelism;
    private final GTableDescription description;
    private final GContext gContext;

    public GTableSubKeyedValueImpl(GTableDescription description, int startGroup, int numberGroups, int maxParallelism, GContext context) {
        Preconditions.checkArgument((startGroup >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((numberGroups > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxParallelism >= numberGroups ? 1 : 0) != 0, (Object)"Max parallelism must bigger thant groups of current table.");
        this.startGroup = startGroup;
        this.numberGroups = numberGroups;
        this.endGroup = startGroup + numberGroups;
        this.maxParallelism = maxParallelism;
        this.description = (GTableDescription)Preconditions.checkNotNull((Object)description);
        this.gContext = (GContext)Preconditions.checkNotNull((Object)context);
        this.regions = new GRegionKMapImpl[numberGroups];
    }

    @Override
    public GTableDescription getTableDescription() {
        return this.description;
    }

    @Override
    public GRegionKMapImpl<K, N, V> getRegion(K key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key, this.maxParallelism);
        int offset = group - this.startGroup;
        GRegionKMapImpl region = this.regions[offset];
        if (region == null) {
            this.regions[offset] = region = (GRegionKMapImpl)this.description.createRegion(this.gContext, this, new GRegionIDImpl(0, group));
        }
        return region;
    }

    @Override
    public Iterator<GRegion> regionIterator() {
        return new Iterator<GRegion>(){
            private int currentIndex = 0;

            private void advance() {
                ++this.currentIndex;
                while (this.currentIndex < GTableSubKeyedValueImpl.this.regions.length && GTableSubKeyedValueImpl.this.regions[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex < GTableSubKeyedValueImpl.this.regions.length && GTableSubKeyedValueImpl.this.regions[this.currentIndex] != null) {
                    return true;
                }
                this.advance();
                return this.currentIndex < GTableSubKeyedValueImpl.this.regions.length;
            }

            @Override
            public GRegion next() {
                return GTableSubKeyedValueImpl.this.regions[this.currentIndex++];
            }
        };
    }

    @Override
    public Iterator<GRegion> indexRegionIterator() {
        return Collections.emptyIterator();
    }

    @Override
    public void setRegion(int idx, GRegion region) {
        Preconditions.checkArgument((idx >= this.startGroup && idx < this.endGroup ? 1 : 0) != 0);
        this.regions[idx - this.startGroup] = (GRegionKMapImpl)region;
    }

    @Override
    public void setIndexRegion(int idx, GRegion indexRegion) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public GTableDescription getIndexDescription() {
        throw new UnsupportedOperationException();
    }
}

