/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKSortedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableKeyedSortedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;

public class KSortedMapTableDescription<K, MK, MV>
implements GTableDescription {
    private final String tableName;
    private final int startGroup;
    private final int numberGroups;
    private final int maxParallelism;
    private final PageSerdeFlink2Key<K, MK, MV> pageSerdeFlink;

    public KSortedMapTableDescription(String tableName, int startGroup, int numberGroups, int maxParallelism, PageSerdeFlink2Key<K, MK, MV> pageSerdeFlink) {
        this.tableName = tableName;
        this.startGroup = startGroup;
        this.numberGroups = numberGroups;
        this.maxParallelism = maxParallelism;
        this.pageSerdeFlink = pageSerdeFlink;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public GTable createTable(GContext gContext) {
        return new GTableKeyedSortedMapImpl(this, this.startGroup, this.numberGroups, this.maxParallelism, gContext);
    }

    @Override
    public GRegion createRegion(GContext gContext, GTable gTable, GRegionID regionId) {
        GRegionContext context = new GRegionContext(gContext, this.tableName, regionId, this.pageSerdeFlink);
        return new GRegionKSortedMapImpl(context);
    }

    @Override
    public GRegion createRegion(GContext gContext, GTable gTable, GRegionID regionId, PageIndex pageIndex) {
        GRegionContext context = new GRegionContext(gContext, this.tableName, regionId, this.pageSerdeFlink);
        return new GRegionKSortedMapImpl(context, pageIndex);
    }

    @Override
    public GRegion createRegion(GRegionContext regionContext, PageIndex pageIndex) {
        return new GRegionKMapImpl(regionContext, pageIndex);
    }

    @Override
    public PageSerdeFlink getPageSerde() {
        return this.pageSerdeFlink;
    }
}

