/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.memstore;

import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.memstore.AbstractWriteBufferKMapHashImpl;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.Segment;
import org.apache.flink.runtime.state.gemini.engine.memstore.SegmentKMap;
import org.apache.flink.runtime.state.gemini.engine.memstore.SegmentKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBufferKSortedMapHashImpl<K, MK, MV>
extends AbstractWriteBufferKMapHashImpl<K, MK, MV> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteBufferKSortedMapHashImpl.class);
    private final GComparator<MK> gComparator;

    public WriteBufferKSortedMapHashImpl(GRegion gRegion, EventExecutor eventExecutor, PageStore pageStore, GComparator<MK> gComparator) {
        super(gRegion, eventExecutor, pageStore);
        this.gComparator = gComparator;
        this.initActive();
    }

    @Override
    protected void initActive() {
        this.active = new SegmentKMapImpl(this.segmentID++, this.gRegionContext, this.gComparator);
    }

    @Override
    Segment addFlushingSegment() {
        SegmentKMap result = this.active;
        this.snapshotQueue.add(this.active);
        this.gRegionContext.getWriteBufferStats().addFlushingSegmentCount(1);
        this.active = new SegmentKMapImpl(this.segmentID++, this.gRegionContext, this.gComparator);
        return result;
    }

    @Override
    public Map<MK, GSValue<MV>> createPOJOMap() {
        return new TreeMap(this.gComparator.getJDKCompactor());
    }
}

