/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.memstore;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferManager;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

public class WriteBufferStats {
    private volatile int averageKeyLen = -2;
    private volatile int averageValueLen = -1;
    private AtomicInteger totalRecordCount = new AtomicInteger(0);
    private AtomicInteger totalFlushingRecordCount = new AtomicInteger(0);
    private AtomicInteger flushingSegmentCount = new AtomicInteger(0);
    private final WriteBufferManager writeBufferManager;

    public WriteBufferStats(WriteBufferManager writeBufferManager) {
        this.writeBufferManager = writeBufferManager;
    }

    public int getAverageKVSize() {
        return this.averageKeyLen + this.averageValueLen;
    }

    public int getAverageKeyLen() {
        return this.averageKeyLen;
    }

    public int getAverageValueLen() {
        return this.averageValueLen;
    }

    public int getTotalRecordCount() {
        return this.totalRecordCount.get();
    }

    public int getFlushingSegmentCount() {
        return this.flushingSegmentCount.get();
    }

    public void setAverageKeyLen(int averageKeyLen) {
        this.averageKeyLen = averageKeyLen;
    }

    public void setAverageValueLen(int averageValueLen) {
        this.averageValueLen = averageValueLen;
    }

    public void addTotalRecordCount(int totalRecordCount) {
        this.totalRecordCount.addAndGet(totalRecordCount);
        this.writeBufferManager.addTotalRecordCount(totalRecordCount);
    }

    public void addTotalFlushingRecordCount(int totalRecordCount) {
        this.totalFlushingRecordCount.addAndGet(totalRecordCount);
        this.writeBufferManager.addTotalFlushingRecordCount(totalRecordCount);
    }

    public void addFlushingSegmentCount(int flushingSegmentCount) {
        this.flushingSegmentCount.addAndGet(flushingSegmentCount);
        this.writeBufferManager.addTotalFlushingSegmentCount(flushingSegmentCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("averageKeyLen", this.averageKeyLen).add("averageValueLen", this.averageValueLen).add("totalRecordCount", (Object)this.totalRecordCount).add("totalFlushingRecordCount", (Object)this.totalFlushingRecordCount).add("flushingSegmentCount", (Object)this.flushingSegmentCount).toString();
    }
}

