/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.ExceptionStat;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsBase;

public class ExceptionMetrics
extends MetricsBase {
    public static final String FILE_SHIFT_TOTAL_COUNT = "totalFileShiftCount";
    public static final String FILEWRITER_SHIFT_TOTAL_COUNT = "totalFileWriterShiftCount";
    private boolean hasRegistered;

    public ExceptionMetrics(MetricGroup metricGroup, int sampleCountInterval) {
        this(metricGroup, sampleCountInterval, 5);
    }

    public ExceptionMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
        super(metricGroup, sampleCountInterval, histogramWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ExceptionStat exceptionStat) {
        ExceptionMetrics exceptionMetrics = this;
        synchronized (exceptionMetrics) {
            if (this.hasRegistered) {
                return;
            }
            this.hasRegistered = true;
        }
        this.getGaugeMetric(FILE_SHIFT_TOTAL_COUNT, () -> exceptionStat.addTotalWriterException(0));
        this.getGaugeMetric(FILEWRITER_SHIFT_TOTAL_COUNT, () -> exceptionStat.addTotalFileWriterShift(0));
    }
}

