/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCacheStat;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsBase;

public class FileCacheMetrics
extends MetricsBase {
    private static final String HIT_RATIO = "hit_ratio";
    private static final String AVG_LOCAL_WRITE_SIZE = "avg_local_write_size";
    private static final String AVG_LOCAL_WRITE_TIME = "avg_local_write_time";
    private static final String AVG_LOCAL_READ_SIZE = "avg_local_read_size";
    private static final String AVG_LOCAL_READ_TIME = "avg_local_read_time";
    private static final String AVG_DFS_WRITE_SIZE = "avg_dfs_write_size";
    private static final String AVG_DFS_WRITE_TIME = "avg_dfs_write_time";
    private static final String AVG_DFS_READ_SIZE = "avg_dfs_read_size";
    private static final String AVG_DFS_READ_TIME = "avg_dfs_read_time";
    private static final String AVG_COMPRESS_RATIO = "avg_compress_ratio";
    private boolean hasRegistered = false;

    public FileCacheMetrics(MetricGroup metricGroup, int sampleCountInterval) {
        this(metricGroup, sampleCountInterval, 5);
    }

    public FileCacheMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
        super(metricGroup, sampleCountInterval, histogramWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(FileCacheStat fileCacheStat) {
        FileCacheMetrics fileCacheMetrics = this;
        synchronized (fileCacheMetrics) {
            if (this.hasRegistered) {
                return;
            }
            this.hasRegistered = true;
        }
        this.getGaugeMetric(HIT_RATIO, () -> {
            double hit = fileCacheStat.hitCount.get();
            double total = (double)fileCacheStat.missCount.get() + hit;
            return total == 0.0 ? 100.0 : hit / total * 100.0;
        });
        this.getGaugeMetric(AVG_LOCAL_WRITE_SIZE, () -> {
            double total = fileCacheStat.totalLocalWriteCount.get();
            double size = fileCacheStat.totalLocalWriteSize.get();
            return total == 0.0 ? 0.0 : size / total;
        });
        this.getGaugeMetric(AVG_COMPRESS_RATIO, () -> {
            double total = fileCacheStat.totalLocalOriDataSize.get();
            double compressed = fileCacheStat.totalLocalWriteCount.get();
            return compressed == 0.0 ? 0.0 : total / compressed;
        });
        this.getGaugeMetric(AVG_LOCAL_WRITE_TIME, () -> {
            double total = fileCacheStat.totalLocalWriteCount.get();
            double time = fileCacheStat.totalLocalWriteTime.get();
            return total == 0.0 ? 0.0 : time / total;
        });
        this.getGaugeMetric(AVG_LOCAL_READ_SIZE, () -> {
            double total = fileCacheStat.totalLocalReadCount.get();
            double size = fileCacheStat.totalLocalReadSize.get();
            return total == 0.0 ? 0.0 : size / total;
        });
        this.getGaugeMetric(AVG_LOCAL_READ_TIME, () -> {
            double total = fileCacheStat.totalLocalReadCount.get();
            double time = fileCacheStat.totalLocalReadTime.get();
            return total == 0.0 ? 0.0 : time / total;
        });
        this.getGaugeMetric(AVG_DFS_WRITE_SIZE, () -> {
            double total = fileCacheStat.totalDFSWriteCount.get();
            double size = fileCacheStat.totalDFSWriteSize.get();
            return total == 0.0 ? 0.0 : size / total;
        });
        this.getGaugeMetric(AVG_DFS_WRITE_TIME, () -> {
            double total = fileCacheStat.totalDFSWriteCount.get();
            double time = fileCacheStat.totalDFSWriteTime.get();
            return total == 0.0 ? 0.0 : time / total;
        });
        this.getGaugeMetric(AVG_DFS_READ_SIZE, () -> {
            double total = fileCacheStat.totalDFSReadCount.get();
            double size = fileCacheStat.totalDFSReadSize.get();
            return total == 0.0 ? 0.0 : size / total;
        });
        this.getGaugeMetric(AVG_DFS_READ_TIME, () -> {
            double total = fileCacheStat.totalDFSReadCount.get();
            double time = fileCacheStat.totalDFSReadTime.get();
            return total == 0.0 ? 0.0 : time / total;
        });
    }
}

