/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.fs.FileCleanerStat;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsBase;

public class FileCleanerMetrics
extends MetricsBase {
    private static final String RECEIVED_FILES = "received_files";
    private static final String DELETED_FILES = "deleted_files";
    private static final String FAILED_DELETE_FILES = "failed_delete_files";
    private boolean hasRegistered = false;

    public FileCleanerMetrics(MetricGroup metricGroup, int sampleCountInterval) {
        this(metricGroup, sampleCountInterval, 5);
    }

    public FileCleanerMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
        super(metricGroup, sampleCountInterval, histogramWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(FileCleanerStat fileCleanerStat) {
        FileCleanerMetrics fileCleanerMetrics = this;
        synchronized (fileCleanerMetrics) {
            if (this.hasRegistered) {
                return;
            }
            this.hasRegistered = true;
        }
        this.getGaugeMetric(RECEIVED_FILES, () -> fileCleanerStat.addTotalReceivedFile(0));
        this.getGaugeMetric(DELETED_FILES, () -> fileCleanerStat.addTotalDeletedFile(0));
        this.getGaugeMetric(FAILED_DELETE_FILES, () -> fileCleanerStat.addTotalFailedDeletedFiles(0));
    }
}

