/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManagerStat;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsBase;

public class FileManagerMetrics
extends MetricsBase {
    private static final String MAX_USED = "max_used_file";
    private static final String USED = "used_file";
    private static final String WAITING_DB_DELETION = "waiting_db_deletion";
    private static final String WAITING_SNAPSHOT_DELETION = "waiting_snapshot_deletion";
    private static final String MARK_DELETION_FILE = "mark_deletion_file";
    private static final String TOTAL_CREATED_FILE = "total_created_file";
    private static final String TOTAL_DATA_SIZE = "total_data_size";
    private boolean hasRegistered = false;

    public FileManagerMetrics(MetricGroup metricGroup, int sampleCountInterval) {
        this(metricGroup, sampleCountInterval, 5);
    }

    public FileManagerMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
        super(metricGroup, sampleCountInterval, histogramWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(FileManagerStat fileManagerStat) {
        FileManagerMetrics fileManagerMetrics = this;
        synchronized (fileManagerMetrics) {
            if (this.hasRegistered) {
                return;
            }
            this.hasRegistered = true;
        }
        this.getGaugeMetric(MAX_USED, () -> fileManagerStat.maxUsedFile.get());
        this.getGaugeMetric(TOTAL_CREATED_FILE, () -> fileManagerStat.totalCreatedFile.get());
        this.getGaugeMetric(TOTAL_DATA_SIZE, () -> fileManagerStat.totalDataSize.get());
    }

    public void registerUsedFile(Gauge<Integer> gauge) {
        this.getGaugeMetric(USED, gauge);
    }

    public void registerWaitingDbDeletion(Gauge<Integer> gauge) {
        this.getGaugeMetric(WAITING_DB_DELETION, gauge);
    }

    public void registerWaitingSnapshotDeletion(Gauge<Integer> gauge) {
        this.getGaugeMetric(WAITING_SNAPSHOT_DELETION, gauge);
    }

    public void registerMarkDeletionFile(Gauge<Integer> gauge) {
        this.getGaugeMetric(MARK_DELETION_FILE, gauge);
    }
}

