/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsBase;

public class GeminiMetrics
extends MetricsBase {
    private static final String METRIC_GEMINI_GET = "get";
    private static final String METRIC_GEMINI_PUT = "put";
    private static final String METRIC_GEMINI_DELETE = "delete";
    private static final String METRIC_GEMINI_SNAPSHOT_SYNC_PHASE = "sync_snapshot";
    private static final String METRIC_GEMINI_SNAPSHOT_ASYNC_PHASE = "async_snapshot";

    public GeminiMetrics(MetricGroup metricGroup, int sampleCountInterval) {
        this(metricGroup, sampleCountInterval, 5);
    }

    public GeminiMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
        super(metricGroup, sampleCountInterval, histogramWindowSize);
    }

    public Histogram getGetHistogram() {
        return this.getHistogramMetric(METRIC_GEMINI_GET);
    }

    public Histogram getPutHistogram() {
        return this.getHistogramMetric(METRIC_GEMINI_PUT);
    }

    public Histogram getDeleteHistogram() {
        return this.getHistogramMetric(METRIC_GEMINI_DELETE);
    }

    public void reportSnapshotSyncPhase(long latency) {
        this.getGaugeMetric(METRIC_GEMINI_SNAPSHOT_SYNC_PHASE).updateValue(latency);
    }

    public void reportSnapshotAsyncPhase(long latency) {
        this.getGaugeMetric(METRIC_GEMINI_SNAPSHOT_ASYNC_PHASE).updateValue(latency);
    }
}

