/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.metrics.SimpleHistogram;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsRegisterAble;
import org.apache.flink.util.Preconditions;

public class MetricsBase {
    protected final Map<String, Histogram> histogramMetrics = new HashMap<String, Histogram>();
    protected final Map<String, Gauge> gaugeMetrics = new HashMap<String, Gauge>();
    protected final Map<String, Counter> counterMetrics = new HashMap<String, Counter>();
    protected final MetricGroup metricGroup;
    protected final int sampleCountInterval;
    protected final boolean metricsSampleEnabled;
    protected static final int DEFAULT_HISTOGRAM_WINDOW_SIZE = 5;
    protected final int histogramWindowSize;

    MetricsBase(MetricGroup metricGroup, int sampleCountInterval) {
        this(metricGroup, sampleCountInterval, 5);
    }

    MetricsBase(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
        this.metricGroup = (MetricGroup)Preconditions.checkNotNull((Object)metricGroup);
        this.sampleCountInterval = sampleCountInterval;
        this.metricsSampleEnabled = sampleCountInterval > 1;
        Preconditions.checkArgument((histogramWindowSize > 0 ? 1 : 0) != 0);
        this.histogramWindowSize = histogramWindowSize;
    }

    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public void registerMetricsCacheStat(MetricsRegisterAble metricsRegisterAble) {
        metricsRegisterAble.registerMetrics(this.metricGroup);
    }

    public boolean isMetricsSampleEnabled() {
        return this.metricsSampleEnabled;
    }

    public int getSampleCountInterval() {
        return this.sampleCountInterval;
    }

    public Histogram getHistogramMetric(String metricName) {
        return this.getHistogramMetric(metricName, (Histogram)new SimpleHistogram(this.histogramWindowSize));
    }

    public Histogram getHistogramMetric(String metricName, Histogram histogram) {
        Histogram histogramMetric = this.histogramMetrics.get(metricName);
        if (histogramMetric == null) {
            histogramMetric = histogram;
            this.metricGroup.histogram(metricName, histogramMetric);
            this.histogramMetrics.put(metricName, histogramMetric);
        }
        return histogramMetric;
    }

    public SimpleGauge<Long> getGaugeMetric(String metricName) {
        return (SimpleGauge)this.getGaugeMetric(metricName, new SimpleGauge());
    }

    public <T> Gauge<T> getGaugeMetric(String metricName, Gauge<T> gauge) {
        Gauge<T> gaugeMetric = this.gaugeMetrics.get(metricName);
        if (gaugeMetric == null) {
            gaugeMetric = gauge;
            this.metricGroup.gauge(metricName, gaugeMetric);
            this.gaugeMetrics.put(metricName, gaugeMetric);
        }
        return gaugeMetric;
    }

    public Counter getCounterMetric(String metricName) {
        return this.getCounterMetric(metricName, (Counter)new SimpleCounter());
    }

    public Counter getCounterMetric(String metricName, Counter counter) {
        Counter counterMetric = this.counterMetrics.get(metricName);
        if (counterMetric == null) {
            counterMetric = counter;
            this.metricGroup.counter(metricName, counterMetric);
            this.counterMetrics.put(metricName, counterMetric);
        }
        return counterMetric;
    }

    static class SimpleGauge<T>
    implements Gauge<T> {
        private volatile T value;

        SimpleGauge() {
        }

        public void updateValue(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }
}

