/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;

public interface DataPage<K, V> {
    public void addReferenceCount();

    public void delReferenceCount(ReferenceCount.ReleaseType var1);

    public int getCheckSum();

    public BinaryValue getBinaryValue(K var1);

    public GSValue<V> get(K var1);

    public boolean contains(K var1);

    public long getVersion();

    public DataPageType getDataPageType();

    public int getSize();

    public int getCount();

    public Map<K, GSValue<V>> getPOJOMap();

    public Set<K> getPOJOSet();

    public Tuple2<DataPage, DataPage> split(int var1, int var2, Allocator var3, GCompressAlgorithm var4);

    public int write(FileWriter var1, PageSerdeFlink<K, V> var2, PageAddress var3, GCompressAlgorithm var4, boolean var5) throws IOException;

    public long getCompactionCount();

    public GBinaryHashMap<K> getGBinaryHashMap();

    public static enum DataPageType {
        KV(1),
        KHashMap(2),
        KSortedMap(3),
        KList(4);

        private final byte code;

        private DataPageType(byte c) {
            this.code = c;
        }

        public byte getCode() {
            return this.code;
        }

        public static DataPageType valueOf(byte pageType) {
            switch (pageType) {
                case 1: {
                    return KV;
                }
                case 2: {
                    return KHashMap;
                }
                case 3: {
                    return KSortedMap;
                }
                case 4: {
                    return KList;
                }
            }
            throw new GeminiRuntimeException("Error PageType:" + pageType);
        }
    }
}

