/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKList;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKVImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GListValueTypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlinkListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryList;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;

public class DataPageKListImpl<K, E>
extends DataPageKVImpl<K, List<GSValue<E>>>
implements DataPageKList<K, E> {
    private final TypeSerializer<E> originValueTypeSerializer;

    public DataPageKListImpl(GBinaryHashMap<K> gBinaryHashMap, TypeSerializer<E> valueTypeSerializer, GListValueTypeSerializer<E> gListValueTypeSerializer) {
        super(gBinaryHashMap, gListValueTypeSerializer);
        this.originValueTypeSerializer = valueTypeSerializer;
    }

    @Override
    public DataPage.DataPageType getDataPageType() {
        return DataPage.DataPageType.KList;
    }

    public static <E> BinaryValue doCompactionKListValue(List<BinaryValue> valueByOrder, TypeSerializer<E> mkTypeSerializer, boolean isMajor, long version, int logicPageId, Allocator allocator) {
        try {
            ArrayList<GBinaryList<GBinaryList<E>>> listByOrder = new ArrayList<GBinaryList<GBinaryList<E>>>();
            long seqID = 0L;
            GValueType firstValueType = null;
            for (BinaryValue binaryValue : valueByOrder) {
                if (binaryValue.getgValueType() == GValueType.Delete) {
                    firstValueType = GValueType.Delete;
                    continue;
                }
                GBinaryList<E> gBinaryList = new GBinaryList<E>(DataPageKMapImpl.getDuplicateBB(binaryValue).getByteBuffer(), mkTypeSerializer);
                seqID = Math.max(seqID, binaryValue.getSeqID());
                listByOrder.add(gBinaryList);
                if (firstValueType != null) continue;
                firstValueType = binaryValue.getgValueType();
            }
            GBinaryList gBinaryListMerge = GBinaryList.mergeGBinaryList(listByOrder, mkTypeSerializer, allocator);
            ByteBuffer bb = gBinaryListMerge == GBinaryList.EMPTY_G_BINARY_LIST ? null : gBinaryListMerge.getData();
            GValueType gValueType = DataPageKListImpl.judgeFinalValueType(bb, firstValueType, isMajor);
            return new BinaryValue(bb, gValueType, seqID, 0, gBinaryListMerge.bytesSize());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Internal BUG " + e.getMessage(), e);
        }
    }

    static GValueType judgeFinalValueType(ByteBuffer bb, GValueType firstValueType, boolean isMajor) {
        if (bb == null) {
            return GValueType.Delete;
        }
        if (firstValueType == GValueType.Delete) {
            return GValueType.PutList;
        }
        return firstValueType;
    }

    public static <K, E> DataPageKListImpl<K, E> readDataPageKListFrom(PageSerdeFlinkListImpl<K, E> pageSerdeFlink, GByteBuffer dataPage, int crc) {
        GBinaryHashMap gBinaryHashMap = new GBinaryHashMap(dataPage, pageSerdeFlink.getKeySerde(), crc);
        return new DataPageKListImpl(gBinaryHashMap, pageSerdeFlink.getValueSerde(), pageSerdeFlink.getgListValueTypeSerializer());
    }

    @Override
    public Tuple2<DataPage, DataPage> getSplitDataByGBinaryMap(GBinaryHashMap<K> gBinaryHashMap1, GBinaryHashMap<K> gBinaryHashMap2) {
        DataPageKListImpl<K, E> dataPage1 = gBinaryHashMap1 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKListImpl<K, E>(gBinaryHashMap1, this.originValueTypeSerializer, (GListValueTypeSerializer)this.valueTypeSerializer);
        DataPageKListImpl<K, E> dataPage2 = gBinaryHashMap2 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKListImpl<K, E>(gBinaryHashMap2, this.originValueTypeSerializer, (GListValueTypeSerializer)this.valueTypeSerializer);
        return Tuple2.of(dataPage1, (Object)dataPage2);
    }
}

