/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMap;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKVImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GUnPooledByteBuffer;

public class DataPageKMapImpl<K, MK, MV>
extends DataPageKVImpl<K, Map<MK, GSValue<MV>>>
implements DataPageKMap<K, MK, MV> {
    protected final TypeSerializer<MK> mkTypeSerializer;
    protected final TypeSerializer<MV> mvTypeSerializer;

    public DataPageKMapImpl(GBinaryHashMap<K> gBinaryHashMap, TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, TypeSerializer<Map<MK, GSValue<MV>>> gMapTypeSerializer) {
        super(gBinaryHashMap, gMapTypeSerializer);
        this.mkTypeSerializer = mkTypeSerializer;
        this.mvTypeSerializer = mvTypeSerializer;
    }

    @Override
    public GSValue<MV> get(K key, MK mapKey) {
        try {
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            if (binaryValue.getgValueType() == GValueType.Delete) {
                return new GSValue<Object>(null, binaryValue.getgValueType(), binaryValue.getSeqID());
            }
            GSValue<MV> reuslt = this.getForMapBinaryValue(this.getBinaryMap(DataPageKMapImpl.getDuplicateBB(binaryValue)), mapKey);
            if (reuslt == null && binaryValue.getgValueType() == GValueType.PutMap) {
                return new GSValue<Object>(null, binaryValue.getgValueType(), binaryValue.getSeqID());
            }
            return reuslt;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    protected GSValue<MV> getForMapBinaryValue(Map<MK, BinaryValue> mapValueMap, MK mapKey) {
        return this.getForBinaryValue(mapValueMap.get(mapKey));
    }

    protected GSValue<MV> getForBinaryValue(BinaryValue mvBinary) {
        try {
            if (mvBinary == null) {
                return null;
            }
            if (mvBinary.getgValueType() == GValueType.Delete) {
                return new GSValue<Object>(null, mvBinary.getgValueType(), mvBinary.getSeqID());
            }
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(mvBinary.getBb(), mvBinary.getValueOffset(), mvBinary.getValueLen());
            Object value = this.mvTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
            return new GSValue<Object>(value, mvBinary.getgValueType(), mvBinary.getSeqID());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("getForBinaryValue has Exception:" + e.getMessage(), e);
        }
    }

    protected static GByteBuffer getDuplicateBB(BinaryValue binaryValue) {
        if (binaryValue.getValueLen() == 0) {
            return null;
        }
        ByteBuffer duplicateByteBuffer = binaryValue.getBb().duplicate();
        duplicateByteBuffer.limit(binaryValue.getValueLen() + binaryValue.getValueOffset());
        duplicateByteBuffer.position(binaryValue.getValueOffset());
        return new GUnPooledByteBuffer(duplicateByteBuffer.slice());
    }

    protected Map<MK, BinaryValue> getBinaryMap(GByteBuffer valueBB) {
        return new GBinaryHashMap<MK>(valueBB, this.mkTypeSerializer);
    }

    @Override
    public boolean contains(K key, MK mapKey) {
        GSValue<MV> mvResult = this.get(key, mapKey);
        return mvResult != null && mvResult.getValue() != null;
    }

    @Override
    public DataPage.DataPageType getDataPageType() {
        return DataPage.DataPageType.KHashMap;
    }

    public static <MK, MV> BinaryValue doCompactionMapValue(List<BinaryValue> valueByOrder, TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, boolean isMajor, long version, int logicPageId, Allocator allcator, @Nullable StateFilter stateFilter, @Nullable GRegionContext gRegionContext) {
        try {
            ArrayList<GBinaryHashMap<MK>> listByOrder = new ArrayList<GBinaryHashMap<MK>>();
            long seqID = 0L;
            GValueType firstValueType = null;
            for (BinaryValue binaryValue : valueByOrder) {
                if (binaryValue.getgValueType() == GValueType.Delete) {
                    firstValueType = GValueType.Delete;
                    continue;
                }
                GBinaryHashMap<MK> mapValue = new GBinaryHashMap<MK>(DataPageKMapImpl.getDuplicateBB(binaryValue), mkTypeSerializer);
                seqID = Math.max(seqID, binaryValue.getSeqID());
                listByOrder.add(mapValue);
                if (firstValueType != null) continue;
                firstValueType = binaryValue.getgValueType();
            }
            int index = 0;
            Map<BinaryKey, BinaryValue> newMap = ((GBinaryHashMap)listByOrder.get(index)).getBinaryMap();
            long compactionCount = ((GBinaryHashMap)listByOrder.get(index)).getCompactionCount();
            ++index;
            while (index < listByOrder.size()) {
                newMap.putAll(((GBinaryHashMap)listByOrder.get(index)).getBinaryMap());
                compactionCount += ((GBinaryHashMap)listByOrder.get(index)).getCompactionCount();
                ++index;
            }
            GBinaryHashMap<MK> gBinaryHashMap = GBinaryHashMap.ofBinaryList(DataPage.DataPageType.KV, isMajor, version, logicPageId, mkTypeSerializer, allcator, newMap, compactionCount, stateFilter, gRegionContext);
            ByteBuffer bb = gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : gBinaryHashMap.getData();
            GValueType gValueType = DataPageKMapImpl.judgeFinalValueType(bb, firstValueType, isMajor);
            return new BinaryValue(bb, gValueType, seqID, 0, gBinaryHashMap.bytesSize());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Internal BUG " + e.getMessage(), e);
        }
    }

    static GValueType judgeFinalValueType(ByteBuffer bb, GValueType firstValueType, boolean isMajor) {
        if (bb == null) {
            return GValueType.Delete;
        }
        if (firstValueType == GValueType.Delete) {
            return GValueType.PutMap;
        }
        return firstValueType;
    }

    protected static <MK> Map<BinaryKey, BinaryValue> doCompactValueToBinaryMap(List<BinaryValue> binaryValueReversedOrderList, TypeSerializer<MK> mkTypeSerializer) {
        try {
            ArrayList<GBinaryHashMap<MK>> listByReversedOrder = new ArrayList<GBinaryHashMap<MK>>();
            for (BinaryValue binaryValue : binaryValueReversedOrderList) {
                GBinaryHashMap<MK> mapValue = new GBinaryHashMap<MK>(DataPageKMapImpl.getDuplicateBB(binaryValue), mkTypeSerializer);
                listByReversedOrder.add(mapValue);
            }
            int index = listByReversedOrder.size() - 1;
            Map<BinaryKey, BinaryValue> newMap = ((GBinaryHashMap)listByReversedOrder.get(index)).getBinaryMap();
            --index;
            while (index >= 0) {
                newMap.putAll(((GBinaryHashMap)listByReversedOrder.get(index)).getBinaryMap());
                --index;
            }
            return newMap;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Internal BUG " + e.getMessage(), e);
        }
    }

    public static <K, MK, MV> DataPageKMapImpl<K, MK, MV> readKMapPageFrom(PageSerdeFlink2Key<K, MK, MV> pageSerdeFlink, GByteBuffer dataPage, int crc) {
        GBinaryHashMap gBinaryHashMap = new GBinaryHashMap(dataPage, pageSerdeFlink.getKeySerde(), crc);
        return new DataPageKMapImpl(gBinaryHashMap, pageSerdeFlink.getKey2Serde(), pageSerdeFlink.getValueSerde(), pageSerdeFlink.getMapValueTypeSerializer());
    }

    @Override
    public Tuple2<DataPage, DataPage> getSplitDataByGBinaryMap(GBinaryHashMap<K> gBinaryHashMap1, GBinaryHashMap<K> gBinaryHashMap2) {
        DataPageKMapImpl<K, MK, MV> dataPage1 = gBinaryHashMap1 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKMapImpl<K, MK, MV>(gBinaryHashMap1, this.mkTypeSerializer, this.mvTypeSerializer, this.valueTypeSerializer);
        DataPageKMapImpl<K, MK, MV> dataPage2 = gBinaryHashMap2 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKMapImpl<K, MK, MV>(gBinaryHashMap2, this.mkTypeSerializer, this.mvTypeSerializer, this.valueTypeSerializer);
        return Tuple2.of(dataPage1, (Object)dataPage2);
    }
}

