/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValueMap;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValueMapEntry;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractGMapValueTypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKSortedMap;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinarySortedMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;

public class DataPageKSortedMapImpl<K, MK, MV>
extends DataPageKMapImpl<K, MK, MV>
implements DataPageKSortedMap<K, MK, MV> {
    private final GComparator<MK> gComparator;

    public DataPageKSortedMapImpl(GBinaryHashMap<K> gBinaryHashMap, TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, AbstractGMapValueTypeSerializer<MK, MV> gSortedMapValueTypeSerialiZer, GComparator<MK> gComparator) {
        super(gBinaryHashMap, mkTypeSerializer, mvTypeSerializer, gSortedMapValueTypeSerialiZer);
        this.gComparator = gComparator;
    }

    protected GBinarySortedMap<MK> getBinaryMap(GByteBuffer valueBB) {
        return new GBinarySortedMap<MK>(valueBB.getByteBuffer(), this.mkTypeSerializer, this.gComparator);
    }

    @Override
    public GSValueMapEntry<MK, MV> firstEntry(K key) {
        return this.getFirstOrLastEntry(key, true);
    }

    @Override
    public GSValueMapEntry<MK, MV> lastEntry(K key) {
        return this.getFirstOrLastEntry(key, false);
    }

    private GSValueMapEntry<MK, MV> getFirstOrLastEntry(K key, boolean first) {
        try {
            Object mkey;
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            GValueType mapType = binaryValue.getgValueType();
            if (binaryValue.getgValueType() == GValueType.Delete) {
                return new GSValueMapEntry(null, mapType, binaryValue.getSeqID());
            }
            Map sortedMap = this.getBinaryMap(DataPageKSortedMapImpl.getDuplicateBB(binaryValue));
            Object MK = mkey = first ? ((GBinarySortedMap)sortedMap).firstKey() : ((GBinarySortedMap)sortedMap).lastKey();
            if (mkey == null) {
                return new GSValueMapEntry(null, mapType, binaryValue.getSeqID());
            }
            GSValue gsValue = this.getForMapBinaryValue(sortedMap, mkey);
            return new GSValueMapEntry(mkey, gsValue, mapType, binaryValue.getSeqID());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    @Override
    public GSValueMap<MK, MV> head(K key, MK endMapKey) {
        return this.subMap(key, null, endMapKey);
    }

    @Override
    public GSValueMap<MK, MV> tail(K key, MK startMapKey) {
        return this.subMap(key, startMapKey, null);
    }

    @Override
    public GSValueMap<MK, MV> subMap(K key, MK startMapKey, MK endMapKey) {
        try {
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            GValueType mapType = binaryValue.getgValueType();
            if (binaryValue.getgValueType() == GValueType.Delete) {
                return new GSValueMap(null, GValueType.Delete, binaryValue.getSeqID());
            }
            Map sortedMap = this.getBinaryMap(DataPageKSortedMapImpl.getDuplicateBB(binaryValue));
            SortedMap<MK, BinaryValue> subSortedMap = ((GBinarySortedMap)sortedMap).subMap(startMapKey, endMapKey);
            if (subSortedMap == null || subSortedMap.size() == 0) {
                return new GSValueMap(null, mapType, binaryValue.getSeqID());
            }
            SortedMap result = Maps.transformEntries(subSortedMap, (mk, mv) -> this.getForBinaryValue((BinaryValue)mv));
            return new GSValueMap(result, mapType, binaryValue.getSeqID());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    @Override
    public DataPage.DataPageType getDataPageType() {
        return DataPage.DataPageType.KSortedMap;
    }

    public static <MK> BinaryValue doCompactionSortedMapValue(List<BinaryValue> valueByOrder, TypeSerializer<MK> mkTypeSerializer, GComparator<MK> gComparator, boolean isMajor, long version, int logicPageId, Allocator allocator, @Nullable StateFilter stateFilter, @Nullable GRegionContext gRegionContext) {
        try {
            ArrayList<GBinarySortedMap<MK>> listByOrder = new ArrayList<GBinarySortedMap<MK>>();
            long seqID = 0L;
            GValueType firstValueType = null;
            for (BinaryValue binaryValue : valueByOrder) {
                if (binaryValue.getgValueType() == GValueType.Delete) {
                    firstValueType = GValueType.Delete;
                    continue;
                }
                GBinarySortedMap<MK> mapValue = new GBinarySortedMap<MK>(DataPageKSortedMapImpl.getDuplicateBB(binaryValue).getByteBuffer(), mkTypeSerializer, gComparator);
                seqID = Math.max(seqID, binaryValue.getSeqID());
                listByOrder.add(mapValue);
                if (firstValueType != null) continue;
                firstValueType = binaryValue.getgValueType();
            }
            int index = 0;
            Map<BinaryKey, BinaryValue> newMap = ((GBinarySortedMap)listByOrder.get(index)).getBinaryMap();
            long compactionCount = ((GBinarySortedMap)listByOrder.get(index)).getCompactionCount();
            ++index;
            while (index < listByOrder.size()) {
                newMap.putAll(((GBinarySortedMap)listByOrder.get(index)).getBinaryMap());
                compactionCount += ((GBinarySortedMap)listByOrder.get(index)).getCompactionCount();
                ++index;
            }
            GBinarySortedMap<MK> gBinarySortedMap = GBinarySortedMap.ofBinaryList(DataPage.DataPageType.KV, isMajor, version, logicPageId, mkTypeSerializer, gComparator, allocator, newMap, compactionCount, stateFilter, gRegionContext);
            ByteBuffer bb = gBinarySortedMap == GBinarySortedMap.EMPTY_G_BINARY_SORTEDMAP ? null : gBinarySortedMap.getData();
            GValueType gValueType = DataPageKSortedMapImpl.judgeFinalValueType(bb, firstValueType, isMajor);
            return new BinaryValue(bb, gValueType, seqID, 0, gBinarySortedMap.bytesSize());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Internal BUG " + e.getMessage(), e);
        }
    }

    public static <K, MK, MV> DataPageKSortedMapImpl<K, MK, MV> readKSortedMapPageFrom(PageSerdeFlink2Key<K, MK, MV> pageSerdeFlink, GByteBuffer dataPage, int crc) {
        GBinaryHashMap gBinaryHashMap = new GBinaryHashMap(dataPage, pageSerdeFlink.getKeySerde(), crc);
        return new DataPageKSortedMapImpl(gBinaryHashMap, pageSerdeFlink.getKey2Serde(), pageSerdeFlink.getValueSerde(), pageSerdeFlink.getMapValueTypeSerializer(), pageSerdeFlink.getMapComparator());
    }

    @Override
    public Tuple2<DataPage, DataPage> getSplitDataByGBinaryMap(GBinaryHashMap<K> gBinaryHashMap1, GBinaryHashMap<K> gBinaryHashMap2) {
        DataPageKSortedMapImpl<K, MK, MV> dataPage1 = gBinaryHashMap1 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKSortedMapImpl<K, MK, MV>(gBinaryHashMap1, this.mkTypeSerializer, this.mvTypeSerializer, (AbstractGMapValueTypeSerializer)this.valueTypeSerializer, this.gComparator);
        DataPageKSortedMapImpl<K, MK, MV> dataPage2 = gBinaryHashMap2 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKSortedMapImpl<K, MK, MV>(gBinaryHashMap2, this.mkTypeSerializer, this.mvTypeSerializer, (AbstractGMapValueTypeSerializer)this.valueTypeSerializer, this.gComparator);
        return Tuple2.of((Object)dataPage1, (Object)dataPage2);
    }
}

