/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCount;
import org.apache.flink.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPageKVImpl<K, V>
implements DataPage<K, V> {
    protected final TypeSerializer<V> valueTypeSerializer;
    protected final GBinaryHashMap<K> gBinaryHashMap;
    private static final Logger LOG = LoggerFactory.getLogger((String)"DataPageImpl");

    public DataPageKVImpl(GBinaryHashMap<K> gBinaryHashMap, TypeSerializer<V> valueTypeSerializer) {
        this.gBinaryHashMap = gBinaryHashMap;
        this.valueTypeSerializer = valueTypeSerializer;
    }

    @Override
    public void addReferenceCount() {
        if (this.gBinaryHashMap != null) {
            this.gBinaryHashMap.addReferenceCount();
        }
    }

    @Override
    public void delReferenceCount(ReferenceCount.ReleaseType releaseType) {
        if (this.gBinaryHashMap != null) {
            this.gBinaryHashMap.delReferenceCount(releaseType);
        }
    }

    @Override
    public int getCheckSum() {
        return this.gBinaryHashMap == null ? 0 : this.gBinaryHashMap.getOriginChecksum();
    }

    @Override
    public BinaryValue getBinaryValue(K key) {
        try {
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            return binaryValue;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    @Override
    public GSValue<V> get(K key) {
        try {
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            if (binaryValue.getgValueType() == GValueType.Delete) {
                return new GSValue<Object>(null, GValueType.Delete, binaryValue.getSeqID());
            }
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
            Object value = this.valueTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
            return new GSValue<Object>(value, binaryValue.getgValueType(), binaryValue.getSeqID());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean contains(K key) {
        GSValue<V> result = this.get(key);
        return result != null && result.getValue() != null;
    }

    @Override
    public long getVersion() {
        return this.gBinaryHashMap.getVersion();
    }

    @Override
    public DataPage.DataPageType getDataPageType() {
        return DataPage.DataPageType.KV;
    }

    @Override
    public int getSize() {
        return this.gBinaryHashMap.bytesSize();
    }

    @Override
    public int getCount() {
        return this.gBinaryHashMap.keyCount();
    }

    @Override
    public Map<K, GSValue<V>> getPOJOMap() {
        return this.gBinaryHashMap.toPOJOMap(this.valueTypeSerializer);
    }

    @Override
    public Set<K> getPOJOSet() {
        return this.gBinaryHashMap.toPOJOSet();
    }

    @Override
    public Tuple2<DataPage, DataPage> split(int curBucketNum, int curIndex, Allocator allocator, GCompressAlgorithm gCompressAlgorithm) {
        Map<K, GSValue<V>> dataMap = this.getPOJOMap();
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        for (Map.Entry<K, GSValue<V>> entry : dataMap.entrySet()) {
            int checkBucketNum;
            int hash = MathUtils.bitMix((int)entry.getKey().hashCode());
            int index = hash & (checkBucketNum = curBucketNum << 1) - 1 - curIndex;
            if (index == 0) {
                list1.add(Tuple2.of(entry.getKey(), entry.getValue()));
                continue;
            }
            list2.add(Tuple2.of(entry.getKey(), entry.getValue()));
        }
        long version = this.getVersion();
        long compactionCount = this.gBinaryHashMap.getCompactionCount();
        int logicPageId = this.gBinaryHashMap.getLogicPageId();
        TypeSerializer<K> keySerializer = this.gBinaryHashMap.getKeyTypeSerializer();
        GBinaryHashMap gBinaryHashMap1 = GBinaryHashMap.of(this.getDataPageType(), list1, keySerializer, this.valueTypeSerializer, version, logicPageId, allocator, compactionCount, gCompressAlgorithm);
        GBinaryHashMap gBinaryHashMap2 = GBinaryHashMap.of(this.getDataPageType(), list2, keySerializer, this.valueTypeSerializer, version, logicPageId + curBucketNum, allocator, compactionCount, gCompressAlgorithm);
        return this.getSplitDataByGBinaryMap(gBinaryHashMap1, gBinaryHashMap2);
    }

    public Tuple2<DataPage, DataPage> getSplitDataByGBinaryMap(GBinaryHashMap<K> gBinaryHashMap1, GBinaryHashMap<K> gBinaryHashMap2) {
        DataPageKVImpl<K, V> dataPage1 = gBinaryHashMap1 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKVImpl<K, V>(gBinaryHashMap1, this.valueTypeSerializer);
        DataPageKVImpl<K, V> dataPage2 = gBinaryHashMap2 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKVImpl<K, V>(gBinaryHashMap2, this.valueTypeSerializer);
        return Tuple2.of(dataPage1, (Object)dataPage2);
    }

    @Override
    public int write(FileWriter writer, PageSerdeFlink<K, V> pageSerdeFlink, PageAddress pageAddress, GCompressAlgorithm gCompressAlgorithm, boolean checksumEnable) throws IOException {
        byte[] data = this.gBinaryHashMap.getDataByte(checksumEnable);
        int dataLen = data.length;
        writer.write(data, 0, dataLen);
        return dataLen;
    }

    @Override
    public long getCompactionCount() {
        return this.gBinaryHashMap.getCompactionCount();
    }

    @Override
    public GBinaryHashMap<K> getGBinaryHashMap() {
        return this.gBinaryHashMap;
    }

    public static <K, V> DataPageKVImpl<K, V> readKVPageFrom(PageSerdeFlink<K, V> pageSerdeFlink, GByteBuffer dataPage, int crc) {
        GBinaryHashMap<K> gBinaryHashMap = new GBinaryHashMap<K>(dataPage, pageSerdeFlink.getKeySerde(), crc);
        return new DataPageKVImpl<K, V>(gBinaryHashMap, pageSerdeFlink.getValueSerde());
    }
}

