/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileReader;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKSortedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKVImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageUtil;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlinkListImpl;
import org.apache.flink.runtime.state.gemini.engine.rm.GUnPooledByteBuffer;

public class DfsDataPageUtil
implements DataPageUtil {
    private final boolean enableChecksum;

    public DfsDataPageUtil(boolean enableChecksum) {
        this.enableChecksum = enableChecksum;
    }

    @Override
    public DataPage getDataPageFromReader(PageSerdeFlink pageSerdeFlink, FileReader reader, int offsetInFile, PageAddress pageAddress) {
        try {
            byte[] diskData = new byte[pageAddress.getDataLen()];
            reader.read(offsetInFile, diskData, 0, pageAddress.getDataLen());
            int crc = 0;
            if (this.enableChecksum) {
                CRC32 crc32 = new CRC32();
                crc32.update(diskData);
                crc = (int)crc32.getValue();
                if (crc != pageAddress.getChecksum()) {
                    throw new GeminiRuntimeException("checkSum fail, " + pageAddress + " when reading from file=" + reader.getFileMeta() + " ,expected=" + pageAddress.getChecksum() + " ,now=" + crc);
                }
            }
            DataPage.DataPageType dataPageType = DataPage.DataPageType.valueOf(diskData[0]);
            GUnPooledByteBuffer gByteBuffer = new GUnPooledByteBuffer(ByteBuffer.wrap(diskData));
            switch (dataPageType) {
                case KV: {
                    return DataPageKVImpl.readKVPageFrom(pageSerdeFlink, gByteBuffer, crc);
                }
                case KHashMap: {
                    return DataPageKMapImpl.readKMapPageFrom((PageSerdeFlink2Key)pageSerdeFlink, gByteBuffer, crc);
                }
                case KSortedMap: {
                    return DataPageKSortedMapImpl.readKSortedMapPageFrom((PageSerdeFlink2Key)pageSerdeFlink, gByteBuffer, crc);
                }
                case KList: {
                    return DataPageKListImpl.readDataPageKListFrom((PageSerdeFlinkListImpl)pageSerdeFlink, gByteBuffer, crc);
                }
            }
            throw new GeminiRuntimeException("error dataType:" + (Object)((Object)dataPageType) + " pageAddress:" + pageAddress);
        }
        catch (Exception e) {
            throw new GeminiRuntimeException(e);
        }
    }
}

