/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractGValueTypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryList;

public final class GListValueTypeSerializer<E>
extends AbstractGValueTypeSerializer<List<GSValue<E>>> {
    private final TypeSerializer<E> valueTypeSerializer;

    public GListValueTypeSerializer(TypeSerializer<E> valueTypeSerializer) {
        this.valueTypeSerializer = valueTypeSerializer;
    }

    public void serialize(List<GSValue<E>> record, DataOutputView target) throws IOException {
        GBinaryList<E> gBinaryList = GBinaryList.ofGBinaryList(record, this.valueTypeSerializer, this.allocator);
        if (gBinaryList == GBinaryList.EMPTY_G_BINARY_LIST) {
            return;
        }
        byte[] bytes = gBinaryList.getDataByte();
        target.write(bytes);
    }

    public List<GSValue<E>> deserialize(DataInputView source) throws IOException {
        ByteBufferDataInputView bufferDataInputView = (ByteBufferDataInputView)source;
        int size = bufferDataInputView.available();
        if (size == 0) {
            return new ArrayList<GSValue<E>>();
        }
        byte[] bytes = new byte[size];
        source.readFully(bytes);
        GBinaryList<E> gBinaryList = new GBinaryList<E>(ByteBuffer.wrap(bytes), this.valueTypeSerializer);
        return gBinaryList.toPOJOList();
    }
}

