/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractGMapValueTypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.GUnPooledByteBuffer;

public final class GMapValueTypeSerializer<MK, MV>
extends AbstractGMapValueTypeSerializer<MK, MV> {
    public GMapValueTypeSerializer(TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, boolean checksumEnable) {
        super(mkTypeSerializer, mvTypeSerializer, checksumEnable);
    }

    public void serialize(Map<MK, GSValue<MV>> record, DataOutputView target) throws IOException {
        List keyValueList = record.entrySet().stream().map(entry -> new Tuple2(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.of(DataPage.DataPageType.KV, keyValueList, this.mkTypeSerializer, this.mvTypeSerializer, -1L, -1, this.allocator, 1L, GCompressAlgorithm.None);
        if (gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP) {
            return;
        }
        byte[] bytes = gBinaryHashMap.getDataByte(this.checksumEnable);
        target.write(bytes);
    }

    public Map<MK, GSValue<MV>> deserialize(DataInputView source) throws IOException {
        ByteBufferDataInputView bufferDataInputView = (ByteBufferDataInputView)source;
        int size = bufferDataInputView.available();
        if (size == 0) {
            return new HashMap(0);
        }
        byte[] bytes = new byte[size];
        source.readFully(bytes);
        GBinaryHashMap gBinaryHashMap = new GBinaryHashMap(new GUnPooledByteBuffer(ByteBuffer.wrap(bytes)), this.mkTypeSerializer);
        return gBinaryHashMap.toPOJOMap(this.mvTypeSerializer);
    }
}

