/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileReader;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKSortedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKVImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageUtil;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlinkListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.compress.CompressorCodec;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.UnpoolAllocatorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDataPageUtil
implements DataPageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDataPageUtil.class);
    private final Allocator allocator;
    private final boolean enableChecksum;

    public LocalDataPageUtil() {
        this(new UnpoolAllocatorImpl(), true);
    }

    public LocalDataPageUtil(Allocator allocator, boolean enableChecksum) {
        this.enableChecksum = enableChecksum;
        this.allocator = allocator;
    }

    @Override
    public DataPage getDataPageFromReader(PageSerdeFlink pageSerdeFlink, FileReader reader, int offsetInFile, PageAddress pageAddress) {
        try {
            GCompressAlgorithm compressAlgorithm = pageAddress.getOndiskDataCompressionAlgorithm();
            CompressorCodec compressorCodec = compressAlgorithm == null ? null : compressAlgorithm.getCompressorCodec();
            GByteBuffer dataGByteBuffer = this.allocator.allocate(pageAddress.getDataLen());
            if (compressorCodec != null) {
                ByteBuffer diskDataBB = compressorCodec.getReuseByteBuffer(pageAddress.getOnDiskDataLen());
                if (diskDataBB.position() != 0) {
                    throw new GeminiRuntimeException("bb pool position should be 0, now is " + diskDataBB.position());
                }
                reader.readByteBuffer(offsetInFile, diskDataBB, 0, pageAddress.getOnDiskDataLen());
                compressorCodec.decompress((ByteBuffer)diskDataBB.flip(), dataGByteBuffer.getByteBuffer());
            } else {
                reader.readByteBuffer(offsetInFile, dataGByteBuffer.getByteBuffer(), 0, pageAddress.getOnDiskDataLen());
            }
            dataGByteBuffer.getByteBuffer().position(0);
            int crc = 0;
            if (this.enableChecksum) {
                CRC32 crc32 = new CRC32();
                crc32.update(dataGByteBuffer.getByteBuffer());
                crc = (int)crc32.getValue();
                if (crc != pageAddress.getChecksum()) {
                    throw new GeminiRuntimeException("checkSum fail, " + pageAddress + " when reading from file=" + reader.getFileMeta() + " ,expected=" + pageAddress.getChecksum() + " ,now=" + crc);
                }
                dataGByteBuffer.getByteBuffer().position(0);
            }
            DataPage.DataPageType dataPageType = DataPage.DataPageType.valueOf(dataGByteBuffer.getByteBuffer().get(0));
            switch (dataPageType) {
                case KV: {
                    return DataPageKVImpl.readKVPageFrom(pageSerdeFlink, dataGByteBuffer, crc);
                }
                case KHashMap: {
                    return DataPageKMapImpl.readKMapPageFrom((PageSerdeFlink2Key)pageSerdeFlink, dataGByteBuffer, crc);
                }
                case KSortedMap: {
                    return DataPageKSortedMapImpl.readKSortedMapPageFrom((PageSerdeFlink2Key)pageSerdeFlink, dataGByteBuffer, crc);
                }
                case KList: {
                    return DataPageKListImpl.readDataPageKListFrom((PageSerdeFlinkListImpl)pageSerdeFlink, dataGByteBuffer, crc);
                }
            }
            throw new GeminiRuntimeException("error dataType:" + (Object)((Object)dataPageType) + " pageAddress:" + pageAddress);
        }
        catch (Exception e) {
            LOG.error("PageAddress:{}", (Object)(pageAddress + " => " + e + " reader=>" + reader.getFileMeta()));
            throw new GeminiRuntimeException(e);
        }
    }
}

