/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.LogicChainedPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStatus;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreStats;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.util.Preconditions;

public class LogicChainedPageImpl
implements LogicChainedPage {
    private volatile int chainIndex = -1;
    private volatile PageAddress[] pageAddresses;
    private volatile byte pageStatus;
    private volatile int pageSize = 0;

    public LogicChainedPageImpl(PageStatus pageStatus) {
        this.pageStatus = pageStatus.getCode();
    }

    public LogicChainedPageImpl(PageStatus pageStatus, int defaultChainLen) {
        this.pageStatus = pageStatus.getCode();
        this.initChainPageImpl(defaultChainLen);
    }

    private LogicChainedPageImpl(LogicChainedPageImpl logicChainedPage, Map<PageAddress, DataPage> allAddReferenceDataPage) {
        this.chainIndex = logicChainedPage.chainIndex;
        if (logicChainedPage.pageAddresses != null) {
            this.pageAddresses = new PageAddress[logicChainedPage.pageAddresses.length];
            System.arraycopy(logicChainedPage.pageAddresses, 0, this.pageAddresses, 0, this.chainIndex + 1);
        }
        for (int i = 0; i <= this.chainIndex; ++i) {
            DataPage dataPage = this.pageAddresses[i].getDataPage();
            if (dataPage == null) continue;
            allAddReferenceDataPage.put(this.pageAddresses[i], dataPage);
        }
        this.pageStatus = logicChainedPage.pageStatus;
    }

    private void initChainPageImpl(int defaultChainLen) {
        Preconditions.checkArgument((defaultChainLen >= 3 ? 1 : 0) != 0, (Object)"defaultChainLen too small");
        this.pageAddresses = new PageAddress[defaultChainLen];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPageStatus(PageStatus expectedPageStatus, PageStatus targetStatus) {
        if (expectedPageStatus == null) {
            this.pageStatus = targetStatus.getCode();
            return true;
        }
        if (this.pageStatus != expectedPageStatus.getCode()) {
            return false;
        }
        LogicChainedPageImpl logicChainedPageImpl = this;
        synchronized (logicChainedPageImpl) {
            if (this.pageStatus != expectedPageStatus.getCode()) {
                return false;
            }
            this.pageStatus = targetStatus.getCode();
            return true;
        }
    }

    @Override
    public void addPageSize(int pageSize) {
        this.pageSize += pageSize;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public PageStatus getPageStatus() {
        return PageStatus.valueOf(this.pageStatus);
    }

    @Override
    public PageAddress getPageAddress(int chainIndex) {
        Preconditions.checkArgument((chainIndex >= 0 && chainIndex <= this.chainIndex ? 1 : 0) != 0, (Object)"logicPage overflow");
        return this.pageAddresses[chainIndex];
    }

    @Override
    public PageAddress createPage(long initRequestCount, DataPage dataPage) {
        PageAddress pageAddress;
        Preconditions.checkArgument((this.chainIndex < this.pageAddresses.length ? 1 : 0) != 0, (Object)"logicPage overflow");
        this.checkSpace();
        this.pageAddresses[this.chainIndex + 1] = pageAddress = new PageAddress(initRequestCount, dataPage);
        ++this.chainIndex;
        return pageAddress;
    }

    @Override
    public int insertPage(PageAddress pageAddress) {
        Preconditions.checkArgument((this.chainIndex < this.pageAddresses.length ? 1 : 0) != 0, (Object)"logicPage overflow");
        this.checkSpace();
        this.pageAddresses[++this.chainIndex] = pageAddress;
        return this.chainIndex;
    }

    private void checkSpace() {
        if (this.chainIndex == this.pageAddresses.length - 1) {
            PageAddress[] newpageAddresses = new PageAddress[this.pageAddresses.length + 1];
            System.arraycopy(this.pageAddresses, 0, newpageAddresses, 0, this.pageAddresses.length);
            this.pageAddresses = newpageAddresses;
        }
    }

    @Override
    public int getCurrentPageChainIndex() {
        return this.chainIndex;
    }

    @Override
    public int getPageChainCapacity() {
        return this.pageAddresses.length;
    }

    @Override
    public LogicChainedPage deepCopy(Map<PageAddress, DataPage> allAddReferenceDataPage) {
        if (this == PageIndexHashImpl.WAIT_SPLITTING) {
            return PageIndexHashImpl.WAIT_SPLITTING;
        }
        return new LogicChainedPageImpl(this, allAddReferenceDataPage);
    }

    @Override
    public Iterator<PageAddress> pageIterator() {
        if (this.pageAddresses == null) {
            return Collections.emptyIterator();
        }
        return Arrays.stream(this.pageAddresses).filter(pageAddress -> pageAddress != null).collect(Collectors.toList()).iterator();
    }

    @Override
    public void snapshot(@Nullable RegionSnapshot localRegionSnapshot, RegionSnapshot dfsRegionSnapshot) throws IOException {
        this.writeInt(localRegionSnapshot, dfsRegionSnapshot, this.chainIndex);
        for (int i = 0; i <= this.chainIndex; ++i) {
            PageAddress pageAddress = this.pageAddresses[i];
            int len = pageAddress.getDataLen();
            int checksum = pageAddress.getChecksum();
            long requesetCount = pageAddress.getRequestCount();
            long localAddress = pageAddress.getLocalAddress();
            long dfsAddress = pageAddress.getDfsAddress();
            this.writeInt(localRegionSnapshot, dfsRegionSnapshot, len);
            this.writeInt(localRegionSnapshot, dfsRegionSnapshot, checksum);
            this.writeLong(localRegionSnapshot, dfsRegionSnapshot, requesetCount);
            this.writeLong(localRegionSnapshot, dfsRegionSnapshot, dfsAddress);
            if (localRegionSnapshot != null) {
                if (pageAddress.isLocalValid()) {
                    localRegionSnapshot.getWriter().writeBoolean(true);
                    localRegionSnapshot.getWriter().writeLong(localAddress);
                } else {
                    localRegionSnapshot.getWriter().writeBoolean(false);
                }
            }
            dfsRegionSnapshot.getWriter().writeBoolean(false);
            if (localRegionSnapshot != null) {
                localRegionSnapshot.updateFileMeta(localAddress, 1, len, true);
                localRegionSnapshot.updateFileMeta(dfsAddress, 1, len, false);
            }
            dfsRegionSnapshot.updateFileMeta(dfsAddress, 1, len, false);
        }
    }

    private void writeInt(RegionSnapshot regionSnapshot1, RegionSnapshot regionSnapshot2, int value) throws IOException {
        if (regionSnapshot1 != null) {
            regionSnapshot1.getWriter().writeInt(value);
        }
        if (regionSnapshot2 != null) {
            regionSnapshot2.getWriter().writeInt(value);
        }
    }

    private void writeLong(RegionSnapshot regionSnapshot1, RegionSnapshot regionSnapshot2, long value) throws IOException {
        if (regionSnapshot1 != null) {
            regionSnapshot1.getWriter().writeLong(value);
        }
        if (regionSnapshot2 != null) {
            regionSnapshot2.getWriter().writeLong(value);
        }
    }

    @Override
    public void restore(SnapshotMetaFile.Reader reader, PageStoreStats pageStoreStats) throws IOException {
        this.chainIndex = reader.readInt();
        this.pageAddresses = new PageAddress[this.chainIndex + 1];
        for (int i = 0; i <= this.chainIndex; ++i) {
            int pageLen;
            int onDiskDataLen = pageLen = reader.readInt();
            int checksum = reader.readInt();
            byte code = -1;
            long requestCount = reader.readLong();
            this.pageAddresses[i] = new PageAddress(pageLen, onDiskDataLen, code, checksum, requestCount);
            long dfsAddress = reader.readLong();
            this.pageAddresses[i].setDfsAddress(dfsAddress);
            this.pageAddresses[i].setDfsStatus(true);
            if (reader.readBoolean()) {
                long localAddress = reader.readLong();
                this.pageAddresses[i].setLocalAddress(localAddress);
                this.pageAddresses[i].setLocalStatus(true);
            }
            this.addPageSize(pageLen);
            pageStoreStats.addLogicPageSize(pageLen);
        }
        pageStoreStats.addLogicPageChainLen(this.chainIndex + 1);
        pageStoreStats.addLogicPageChainCapacity(this.chainIndex + 1);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pageAddresses", (Object)Arrays.toString(this.pageAddresses)).toString();
    }
}

