/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

public class PageAddress {
    private static final byte PAGE_VALID_MASK = 1;
    private static final byte LOCAL_VALID_MASK = 2;
    private static final byte DFS_VALID_MASK = 4;
    private DataPage dataPage;
    private volatile long dfsAddress;
    private volatile long localAddress;
    private volatile long requestCount = 0L;
    private final int onMemDataLen;
    private final int checksum;
    private volatile byte status;

    public PageAddress(long requestCount, DataPage dataPage) {
        this.dataPage = dataPage;
        this.onMemDataLen = dataPage.getSize();
        this.requestCount = requestCount;
        this.status = 1;
        this.checksum = dataPage.getCheckSum();
    }

    public PageAddress(int onMemDataLen, int onDiskDataLen, byte dataLenType, int checksum, long requestCount) {
        this.status = 1;
        this.onMemDataLen = onMemDataLen;
        this.requestCount = requestCount;
        this.checksum = checksum;
    }

    public DataPage getDataPage() {
        if (this.dataPage != null) {
            this.dataPage.addReferenceCount();
        }
        return this.dataPage;
    }

    public DataPage getDataPageNoReference() {
        return this.dataPage;
    }

    public boolean hasDataPage() {
        return this.dataPage != null;
    }

    public long getDfsAddress() {
        return this.dfsAddress;
    }

    public long getLocalAddress() {
        return this.localAddress;
    }

    public long getVersion() {
        return this.dataPage != null ? this.dataPage.getVersion() : -1L;
    }

    public void setDataPage(DataPage dataPage) {
        this.dataPage = dataPage;
    }

    public void setDfsAddress(long dfsAddress) {
        this.dfsAddress = dfsAddress;
    }

    public void setLocalAddress(long localAddress) {
        this.localAddress = localAddress;
    }

    public void setPageStatus(boolean flag) {
        byte st = this.status;
        this.status = (byte)(flag ? st | 1 : st & 0xFFFFFFFE);
    }

    public boolean isPageValid() {
        return (this.status & 1) != 0;
    }

    public void setLocalStatus(boolean flag) {
        byte st = this.status;
        this.status = (byte)(flag ? st | 2 : st & 0xFFFFFFFD);
    }

    public boolean isLocalValid() {
        return (this.status & 2) != 0;
    }

    public void setDfsStatus(boolean flag) {
        byte st = this.status;
        this.status = (byte)(flag ? st | 4 : st & 0xFFFFFFFB);
    }

    public boolean isDfsValid() {
        return (this.status & 4) != 0;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("dataPage", (Object)this.dataPage).add("dfsAddress", this.dfsAddress).add("localAddress", this.localAddress).add("compressCode", (Object)this.getOndiskDataCompressionAlgorithm()).add("onDiskDataLen", this.onMemDataLen).add("onMemDataLen", this.onMemDataLen).add("requestCount", this.requestCount);
        if (this.dataPage != null) {
            helper.add("compactionCount", this.dataPage.getCompactionCount());
        }
        return helper.toString();
    }

    public int getDataLen() {
        return this.onMemDataLen;
    }

    public int getOnDiskDataLen() {
        return this.onMemDataLen;
    }

    public GCompressAlgorithm getOndiskDataCompressionAlgorithm() {
        return GCompressAlgorithm.None;
    }

    public void afterFlush(int onDiskDataLen, GCompressAlgorithm gCompressAlgorithm) {
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public void addRequestCount(int i) {
        this.requestCount += (long)i;
    }

    public int getChecksum() {
        return this.checksum;
    }
}

