/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.Objects;
import org.apache.flink.runtime.state.gemini.engine.page.LogicChainedPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;

public class PageIndexContextHashImpl
implements PageIndexContext {
    private final int curBucketNum;
    private final int curIndex;
    private final LogicChainedPage pageID;
    private final boolean needSplit;

    public PageIndexContextHashImpl(int curBucketNum, int curIndex, LogicChainedPage pageID, boolean needSplit) {
        this.curBucketNum = curBucketNum;
        this.curIndex = curIndex;
        this.pageID = pageID;
        this.needSplit = needSplit;
    }

    public static PageIndexContext of(int curBucketNum, int curIndex, LogicChainedPage pageID, boolean needSplit) {
        return new PageIndexContextHashImpl(curBucketNum, curIndex, pageID, needSplit);
    }

    public static PageIndexContext of(PageIndexContextHashImpl pageIndexContext, LogicChainedPage logicChainedPage) {
        return new PageIndexContextHashImpl(pageIndexContext.curBucketNum, pageIndexContext.curIndex, logicChainedPage, false);
    }

    @Override
    public LogicChainedPage getPageID() {
        return this.pageID;
    }

    @Override
    public int getPageIndexID() {
        return this.curIndex;
    }

    @Override
    public boolean isNeedSplit() {
        return this.needSplit;
    }

    public int getCurBucketNum() {
        return this.curBucketNum;
    }

    public int getCurIndex() {
        return this.curIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageIndexContextHashImpl that = (PageIndexContextHashImpl)o;
        return this.curBucketNum == that.curBucketNum && this.curIndex == that.curIndex && this.needSplit == that.needSplit && Objects.equals(this.pageID, that.pageID);
    }

    public int hashCode() {
        return Objects.hash(this.curBucketNum, this.curIndex, this.pageID, this.needSplit);
    }
}

