/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.LogicChainedPage;
import org.apache.flink.runtime.state.gemini.engine.page.LogicChainedPageImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContextHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStatus;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreStats;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterators;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageIndexHashImpl<K>
implements PageIndex<K> {
    private static final Logger LOG = LoggerFactory.getLogger(PageIndexHashImpl.class);
    public static final LogicChainedPage WAIT_SPLITTING = new LogicChainedPageImpl(PageStatus.Init);
    public static final LogicChainedPage NO_PAGE = null;
    private final int baseBucketNum;
    private volatile int curBucketNum;
    private final PageStore pageStore;
    private final PageStoreStats pageStoreStats;
    private volatile LogicChainedPage[] pageIndex;
    private final int logicPageChainLenDefault;

    public PageIndexHashImpl(GConfiguration config, PageStore pageStore, PageStoreStats pageStoreStats) {
        int configBucktNum = config.getPageIndexBucketLenDefault();
        Preconditions.checkArgument(((configBucktNum & configBucktNum - 1) == 0 ? 1 : 0) != 0, (Object)"curBucketNum should be a power of 2.");
        this.baseBucketNum = configBucktNum;
        this.curBucketNum = configBucktNum;
        this.pageIndex = new LogicChainedPage[configBucktNum];
        this.pageStore = pageStore;
        this.pageStoreStats = pageStoreStats;
        this.logicPageChainLenDefault = config.getLogicTableDefaultChainLen();
        this.pageStoreStats.setIndexCapacity(this.curBucketNum);
    }

    public PageIndexHashImpl(LogicChainedPage[] pageIndex, PageStore pageStore, PageStoreStats pageStoreStats, int baseBucketNum, int curBucketNum, int logicPageChainLenDefault) {
        this.baseBucketNum = baseBucketNum;
        this.curBucketNum = curBucketNum;
        this.pageIndex = pageIndex;
        this.pageStore = pageStore;
        this.pageStoreStats = pageStoreStats;
        this.logicPageChainLenDefault = logicPageChainLenDefault;
        this.pageStoreStats.setIndexCapacity(curBucketNum);
    }

    private PageIndexHashImpl(PageIndexHashImpl pageIndexHash, Map<PageAddress, DataPage> allAddReferenceDataPage) {
        this.baseBucketNum = pageIndexHash.baseBucketNum;
        this.curBucketNum = pageIndexHash.curBucketNum;
        this.pageStore = pageIndexHash.pageStore;
        this.pageStoreStats = pageIndexHash.pageStoreStats;
        this.logicPageChainLenDefault = pageIndexHash.logicPageChainLenDefault;
        this.pageIndex = new LogicChainedPage[pageIndexHash.pageIndex.length];
        for (int i = 0; i < this.pageIndex.length; ++i) {
            LogicChainedPage page = pageIndexHash.pageIndex[i];
            if (page == null) continue;
            this.pageIndex[i] = page.deepCopy(allAddReferenceDataPage);
        }
    }

    @Override
    public PageIndexContext getPageIndexContext(K key, boolean createIfMiss) {
        PageIndexContextHashImpl result;
        block3: {
            int hash = MathUtils.bitMix((int)key.hashCode());
            int checkBucketNum = this.curBucketNum;
            int curIndex = hash & checkBucketNum - 1;
            if (createIfMiss) {
                return this.internalGetPageIndexContext(hash, curIndex, checkBucketNum, true);
            }
            while (true) {
                result = (PageIndexContextHashImpl)this.internalGetPageIndexContext(hash, curIndex, checkBucketNum, false);
                if (checkBucketNum != this.curBucketNum) {
                    checkBucketNum = this.curBucketNum;
                    curIndex = hash & checkBucketNum - 1;
                    continue;
                }
                if (result.getCurBucketNum() == this.curBucketNum) break block3;
                PageIndexContextHashImpl checkResult = (PageIndexContextHashImpl)this.internalGetPageIndexContext(hash, hash & this.curBucketNum - 1, this.curBucketNum, false);
                if (result.getCurIndex() == checkResult.getCurIndex()) break;
            }
            return result;
        }
        return result;
    }

    private PageIndexContext internalGetPageIndexContext(int hash, int curIndex, int checkBucketNum, boolean createIfMiss) {
        PageIndexContext result;
        PageIndexContext pageIndexContext = result = this.pageIndex[curIndex] == WAIT_SPLITTING ? this.recursiveGetPageContext(hash, checkBucketNum) : PageIndexContextHashImpl.of(checkBucketNum, curIndex, this.pageIndex[curIndex], false);
        if (result.getPageID() != NO_PAGE || !createIfMiss) {
            return result;
        }
        this.pageIndex[curIndex] = this.newLogicChainedPage();
        this.pageStoreStats.addLogicPageCount(1);
        this.pageStoreStats.addLogicPageChainCapacity(this.logicPageChainLenDefault);
        return PageIndexContextHashImpl.of(checkBucketNum, curIndex, this.pageIndex[curIndex], false);
    }

    private PageIndexContext recursiveGetPageContext(int hash, int checkBucketNum) {
        checkBucketNum >>= 1;
        while (checkBucketNum >= this.baseBucketNum) {
            int index = hash & checkBucketNum - 1;
            if (this.pageIndex[index] != WAIT_SPLITTING) {
                return PageIndexContextHashImpl.of(checkBucketNum, index, this.pageIndex[index], true);
            }
            checkBucketNum >>= 1;
        }
        throw new GeminiRuntimeException("Internal Bug!");
    }

    @Override
    public void expand() {
        Object[] pageIndexNew = new LogicChainedPage[this.curBucketNum << 1];
        System.arraycopy(this.pageIndex, 0, pageIndexNew, 0, this.pageIndex.length);
        Arrays.fill(pageIndexNew, this.pageIndex.length, pageIndexNew.length, WAIT_SPLITTING);
        this.pageIndex = pageIndexNew;
        this.curBucketNum = pageIndexNew.length;
        this.pageStoreStats.setIndexCapacity(this.curBucketNum);
    }

    @Override
    public void shrink() {
        this.pageStoreStats.setIndexCapacity(this.curBucketNum);
    }

    @Override
    public void snapshot(@Nullable RegionSnapshot localRegionSnapshot, RegionSnapshot dfsRegionSnapshot) throws IOException {
        this.snapshotPageIndexMeta(localRegionSnapshot);
        this.snapshotPageIndexMeta(dfsRegionSnapshot);
        for (int i = 0; i < this.pageIndex.length; ++i) {
            LogicChainedPage logicChainedPage = this.pageIndex[i];
            if (logicChainedPage == null) {
                this.writeBoolean(localRegionSnapshot, dfsRegionSnapshot, true);
                continue;
            }
            this.writeBoolean(localRegionSnapshot, dfsRegionSnapshot, false);
            if (logicChainedPage == WAIT_SPLITTING) {
                this.writeBoolean(localRegionSnapshot, dfsRegionSnapshot, true);
                continue;
            }
            this.writeBoolean(localRegionSnapshot, dfsRegionSnapshot, false);
            logicChainedPage.snapshot(localRegionSnapshot, dfsRegionSnapshot);
        }
    }

    private void writeBoolean(RegionSnapshot regionSnapshot1, RegionSnapshot regionSnapshot2, boolean value) throws IOException {
        if (regionSnapshot1 != null) {
            regionSnapshot1.getWriter().writeBoolean(value);
        }
        if (regionSnapshot2 != null) {
            regionSnapshot2.getWriter().writeBoolean(value);
        }
    }

    private void snapshotPageIndexMeta(RegionSnapshot regionSnapshot) throws IOException {
        if (regionSnapshot == null) {
            return;
        }
        SnapshotMetaFile.Writer writer = regionSnapshot.getWriter();
        writer.writeInt(this.baseBucketNum);
        writer.writeInt(this.curBucketNum);
        writer.writeInt(this.logicPageChainLenDefault);
        writer.writeInt(this.pageIndex.length);
    }

    @Override
    public boolean updateLogicPageStatus(int pageID, PageStatus expectedStatus, PageStatus targetStatus) {
        return this.pageIndex[pageID].setPageStatus(expectedStatus, targetStatus);
    }

    @Override
    public PageIndex<K> deepCopy(Map<PageAddress, DataPage> allAddReferenceDataPage) {
        return new PageIndexHashImpl<K>(this, allAddReferenceDataPage);
    }

    @Override
    public void removeLogicPage(int baseLogicPageID) {
        this.pageIndex[baseLogicPageID] = NO_PAGE;
        this.pageStoreStats.addLogicPageCount(-1);
    }

    @Override
    public LogicChainedPage getLogicPage(int baseLogicPageID) {
        return this.pageIndex[baseLogicPageID];
    }

    @Override
    public void updateLogicPage(int baseLogicPageID, LogicChainedPage destLogicPage) {
        this.pageIndex[baseLogicPageID] = destLogicPage;
    }

    @Override
    public LogicChainedPage newLogicChainedPage() {
        return new LogicChainedPageImpl(PageStatus.Normal, this.logicPageChainLenDefault);
    }

    @Override
    public Iterator<PageAddress> pageIterator() {
        ArrayList<Iterator<PageAddress>> iteratorLists = new ArrayList<Iterator<PageAddress>>();
        for (LogicChainedPage logicChainedPage : this.pageIndex) {
            if (logicChainedPage == null) continue;
            iteratorLists.add(logicChainedPage.pageIterator());
        }
        return Iterators.concat(iteratorLists.iterator());
    }

    @Override
    public int getIndexCapacity() {
        return this.curBucketNum;
    }

    @Override
    public LogicChainedPage[] getPageIndex() {
        return this.pageIndex;
    }

    public int getBucketNumASPageFinishSplit(int curBucketNum, int curIndex) {
        while (true) {
            if (this.getLogicPage(curIndex) == WAIT_SPLITTING) {
                throw new GeminiRuntimeException("Gemini Internal Bug, want to split a invalid page");
            }
            int checkBucketNum = curBucketNum >> 1;
            if (checkBucketNum <= curIndex || this.getLogicPage(curIndex + checkBucketNum) != WAIT_SPLITTING) break;
            curBucketNum = checkBucketNum;
        }
        return curBucketNum;
    }

    public static class Builder {
        private final int baseBucketNum;
        private final int curBucketNum;
        private final int logicPageChainLenDefault;
        private final LogicChainedPage[] pageIndex;
        private final GRegionContext regionContext;

        public Builder(SnapshotMetaFile.Reader reader, GRegionContext context) throws IOException {
            this.baseBucketNum = reader.readInt();
            this.curBucketNum = reader.readInt();
            this.logicPageChainLenDefault = reader.readInt();
            this.regionContext = context;
            int pageIndexLength = reader.readInt();
            this.pageIndex = new LogicChainedPage[pageIndexLength];
            for (int i = 0; i < pageIndexLength; ++i) {
                LogicChainedPage logicChainedPage;
                boolean emptyPage = reader.readBoolean();
                if (emptyPage) {
                    logicChainedPage = null;
                } else {
                    boolean waitSplitting = reader.readBoolean();
                    if (waitSplitting) {
                        logicChainedPage = WAIT_SPLITTING;
                    } else {
                        logicChainedPage = new LogicChainedPageImpl(PageStatus.Normal);
                        logicChainedPage.restore(reader, this.regionContext.getPageStoreStats());
                        this.regionContext.getPageStoreStats().addLogicPageCount(1);
                    }
                }
                this.pageIndex[i] = logicChainedPage;
            }
        }

        public PageIndex build() {
            return new PageIndexHashImpl(this.pageIndex, null, this.regionContext.getPageStoreStats(), this.baseBucketNum, this.curBucketNum, this.logicPageChainLenDefault);
        }
    }
}

